/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.jsonoverlay;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.reprezen.jsonoverlay.AbstractJsonOverlay;
import com.reprezen.jsonoverlay.Reference;
import com.reprezen.jsonoverlay.ReferenceRegistry;
import com.reprezen.jsonoverlay.SerializationOptions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;

public abstract class JsonOverlay<V>
extends AbstractJsonOverlay<V> {
    protected static final ObjectMapper mapper = new ObjectMapper();
    protected V value = null;
    protected JsonOverlay<?> parent;
    protected JsonNode json = null;
    protected ReferenceRegistry refReg;
    private String pathInParent = null;
    private Reference reference = null;
    private static final SerializationOptions emptyOptions = new SerializationOptions(new SerializationOptions.Option[0]);

    public JsonOverlay(V value, JsonOverlay<?> parent, ReferenceRegistry refReg) {
        this.value = value;
        this.parent = parent;
        this.refReg = refReg;
    }

    public JsonOverlay(JsonNode json, JsonOverlay<?> parent, ReferenceRegistry refReg) {
        this.json = json;
        this.value = this.fromJson(json);
        this.parent = parent;
        this.refReg = refReg;
    }

    protected void setReference(Reference reference) {
        this.reference = reference;
    }

    @Override
    boolean _isPresent() {
        return this.value != null && !this.json.isMissingNode();
    }

    @Override
    boolean _isElaborated() {
        return true;
    }

    @Override
    AbstractJsonOverlay<?> _find(JsonPointer path) {
        return path.matches() ? this : this._findInternal(path);
    }

    protected abstract AbstractJsonOverlay<?> _findInternal(JsonPointer var1);

    @Override
    AbstractJsonOverlay<?> _find(String path) {
        return this._find(JsonPointer.compile((String)path));
    }

    @Override
    V _get() {
        return this.value;
    }

    @Override
    void _set(V value) {
        this._set(value, true);
    }

    protected void _set(V value, boolean invalidate) {
        this.value = value;
    }

    @Override
    JsonOverlay<?> _getParent() {
        return this.parent;
    }

    protected void setParent(JsonOverlay<?> parent) {
        this.parent = parent;
    }

    protected void setPathInParent(String pathInParent) {
        this.pathInParent = pathInParent;
    }

    @Override
    String _getPathInParent() {
        return this.pathInParent;
    }

    @Override
    String _getPathFromRoot() {
        return this.parent != null ? (this.parent._getParent() != null ? this.parent._getPathFromRoot() : "") + "/" + this.pathInParent : "/";
    }

    @Override
    URL _getJsonReference() {
        URL result = null;
        try {
            if (this.reference != null) {
                result = new URL(this.reference.getCanonicalRefString());
            } else {
                URL parentUrl;
                URL uRL = parentUrl = this.parent != null ? this.parent._getJsonReference() : null;
                if (parentUrl != null) {
                    JsonPointer ptr = JsonPointer.compile((String)parentUrl.getRef());
                    ptr = ptr.append(JsonPointer.compile((String)("/" + this.pathInParent)));
                    result = new URL(parentUrl, "#" + ptr.toString());
                }
            }
        }
        catch (IllegalArgumentException | MalformedURLException exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    JsonOverlay<?> _getRoot() {
        return this.parent != null ? this.parent._getRoot() : this;
    }

    protected abstract V fromJson(JsonNode var1);

    protected void elaborate() {
    }

    @Override
    JsonNode _toJson() {
        return this._toJsonInternal(emptyOptions);
    }

    @Override
    JsonNode _toJson(SerializationOptions.Option ... options) {
        return this._toJsonInternal(new SerializationOptions(options));
    }

    @Override
    JsonNode _toJson(SerializationOptions options) {
        return this._toJsonInternal(options);
    }

    abstract JsonNode _toJsonInternal(SerializationOptions var1);

    protected static ObjectNode jsonObject() {
        return JsonNodeFactory.instance.objectNode();
    }

    protected static ArrayNode jsonArray() {
        return JsonNodeFactory.instance.arrayNode();
    }

    protected static TextNode jsonScalar(String s) {
        return JsonNodeFactory.instance.textNode(s);
    }

    protected static ValueNode jsonScalar(int n) {
        return JsonNodeFactory.instance.numberNode(n);
    }

    protected static ValueNode jsonScalar(long n) {
        return JsonNodeFactory.instance.numberNode(n);
    }

    protected static ValueNode jsonScalar(short n) {
        return JsonNodeFactory.instance.numberNode(n);
    }

    protected static ValueNode jsonScalar(byte n) {
        return JsonNodeFactory.instance.numberNode(n);
    }

    protected static ValueNode jsonScalar(double n) {
        return JsonNodeFactory.instance.numberNode(n);
    }

    protected static ValueNode jsonScalar(float n) {
        return JsonNodeFactory.instance.numberNode(n);
    }

    protected static ValueNode jsonScalar(BigInteger n) {
        return JsonNodeFactory.instance.numberNode(n);
    }

    protected static ValueNode jsonScalar(BigDecimal n) {
        return JsonNodeFactory.instance.numberNode(n);
    }

    protected static ValueNode jsonBoolean(boolean b) {
        return JsonNodeFactory.instance.booleanNode(b);
    }

    protected static MissingNode jsonMissing() {
        return MissingNode.getInstance();
    }

    protected static NullNode jsonNull() {
        return JsonNodeFactory.instance.nullNode();
    }

    protected static final <T> Iterable<T> iterable(final Iterator<T> iterator) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return iterator;
            }
        };
    }

    public String toString() {
        return this._toJson().toString();
    }
}

