/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.jsonoverlay;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.reprezen.jsonoverlay.AbstractJsonOverlay;
import com.reprezen.jsonoverlay.ChildOverlay;
import com.reprezen.jsonoverlay.IJsonOverlay;
import com.reprezen.jsonoverlay.IModelPart;
import com.reprezen.jsonoverlay.JsonOverlay;
import com.reprezen.jsonoverlay.ListOverlay;
import com.reprezen.jsonoverlay.MapOverlay;
import com.reprezen.jsonoverlay.PropertiesOverlay;
import com.reprezen.jsonoverlay.Reference;
import com.reprezen.jsonoverlay.SerializationOptions;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class Overlay<V> {
    private AbstractJsonOverlay<V> overlay;

    public Overlay(IJsonOverlay<V> overlay) {
        this.overlay = (AbstractJsonOverlay)overlay;
    }

    public static <V> Overlay<V> of(IJsonOverlay<V> overlay) {
        return new Overlay<V>(overlay);
    }

    public static <X> Overlay<Map<String, X>> of(MapOverlay<X> overlay) {
        return new Overlay<Map<String, X>>(overlay);
    }

    public static <V> Overlay<Map<String, V>> of(Map<String, V> map) {
        if (map instanceof MapOverlay.WrappedMap) {
            MapOverlay mapOverlay = ((MapOverlay.WrappedMap)map).getOverlay();
            return Overlay.of(mapOverlay);
        }
        return null;
    }

    public static <X> Overlay<Collection<X>> of(ListOverlay<X> overlay) {
        return new Overlay<Collection<X>>(overlay);
    }

    public static <V> Overlay<Collection<V>> of(Collection<V> list) {
        if (list instanceof ListOverlay.WrappedCollection) {
            ListOverlay listOverlay = ((ListOverlay.WrappedCollection)list).getOverlay();
            return Overlay.of(listOverlay);
        }
        return null;
    }

    public Overlay(MapOverlay<V> map, String key) {
        this.overlay = map._get(key);
    }

    public static <V> Overlay<V> of(MapOverlay<V> map, String key) {
        return new Overlay<V>(map, key);
    }

    public Overlay(ListOverlay<V> list, int index) {
        this.overlay = list._get(index);
    }

    public static <V> Overlay<V> of(ListOverlay<V> list, int index) {
        return new Overlay<V>(list, index);
    }

    public Overlay(PropertiesOverlay<?> props, String fieldName, Class<? extends V> type) {
        Object value;
        AbstractJsonOverlay<?> overlay = props._get(fieldName);
        Object object = value = overlay != null ? (Object)overlay._get() : null;
        if (value == null || type.isAssignableFrom(value.getClass())) {
            AbstractJsonOverlay<?> castOverlay1 = overlay;
            if (castOverlay1 instanceof ChildOverlay) {
                JsonOverlay castOverlay2 = ((ChildOverlay)castOverlay1).getOverlay();
                this.overlay = castOverlay2;
            } else {
                this.overlay = castOverlay1;
            }
        } else {
            this.overlay = null;
        }
    }

    public static <V> Overlay<V> of(Object props, String fieldName, Class<? extends V> type) {
        if (props instanceof PropertiesOverlay) {
            PropertiesOverlay castProps = (PropertiesOverlay)props;
            return new Overlay<V>(castProps, fieldName, type);
        }
        return null;
    }

    public final V get() {
        return this.overlay._get();
    }

    public final IJsonOverlay<V> getOverlay() {
        return this.overlay;
    }

    public final MapOverlay<?> getMapOverlay() {
        if (this.overlay instanceof MapOverlay) {
            MapOverlay castOverlay = (MapOverlay)this.overlay;
            return castOverlay;
        }
        return null;
    }

    public final ListOverlay<V> getListOverlay() {
        if (this.overlay instanceof ListOverlay) {
            ListOverlay castOverlay = (ListOverlay)this.overlay;
            return castOverlay;
        }
        return null;
    }

    public static <V> V get(IJsonOverlay<V> overlay) {
        return ((AbstractJsonOverlay)overlay)._get();
    }

    public AbstractJsonOverlay<?> find(JsonPointer path) {
        return this.overlay._find(path);
    }

    public static <V> AbstractJsonOverlay<?> find(IJsonOverlay<V> overlay, JsonPointer path) {
        return ((AbstractJsonOverlay)overlay)._find(path);
    }

    public AbstractJsonOverlay<?> find(String path) {
        return this.overlay._find(path);
    }

    public static <V> AbstractJsonOverlay<?> find(IJsonOverlay<V> overlay, String path) {
        return ((AbstractJsonOverlay)overlay)._find(path);
    }

    public JsonNode toJson() {
        return this.overlay._toJson();
    }

    public static <V> JsonNode toJson(IJsonOverlay<V> overlay) {
        return ((AbstractJsonOverlay)overlay)._toJson();
    }

    public JsonNode toJson(SerializationOptions options) {
        return this.overlay._toJson(options);
    }

    public static <V> JsonNode toJson(IJsonOverlay<V> overlay, SerializationOptions options) {
        return ((AbstractJsonOverlay)overlay)._toJson(options);
    }

    public JsonNode toJson(SerializationOptions.Option ... options) {
        return this.overlay._toJson(options);
    }

    public static <V> JsonNode toJson(IJsonOverlay<V> overlay, SerializationOptions.Option ... options) {
        return ((AbstractJsonOverlay)overlay)._toJson(options);
    }

    public boolean isPresent() {
        return this.overlay._isPresent();
    }

    public static <V> boolean isPresent(IJsonOverlay<V> overlay) {
        return ((AbstractJsonOverlay)overlay)._isPresent();
    }

    public boolean isElaborated() {
        return this.overlay._isElaborated();
    }

    public static <V> boolean isElaborated(IJsonOverlay<V> overlay) {
        return ((AbstractJsonOverlay)overlay)._isElaborated();
    }

    public JsonOverlay<?> getParent() {
        return (JsonOverlay)this.overlay._getParent();
    }

    public static <V> IJsonOverlay<?> getParent(IJsonOverlay<V> overlay) {
        return ((AbstractJsonOverlay)overlay)._getParent();
    }

    public PropertiesOverlay<?> getParentPropertiesOverlay() {
        IJsonOverlay<?> parent = this.getParent();
        while (parent != null) {
            if (parent instanceof PropertiesOverlay) {
                return (PropertiesOverlay)parent;
            }
            parent = Overlay.getParent(parent);
        }
        return null;
    }

    public static <V> PropertiesOverlay<?> getParentPropertiesOverlay(IJsonOverlay<V> overlay) {
        return new Overlay<V>(overlay).getParentPropertiesOverlay();
    }

    public String getPathInParent() {
        return this.overlay._getPathInParent();
    }

    public static <V> String getPathInParent(IJsonOverlay<V> overlay) {
        return ((AbstractJsonOverlay)overlay)._getPathInParent();
    }

    public AbstractJsonOverlay<?> getRoot() {
        return this.overlay._getRoot();
    }

    public static <V> AbstractJsonOverlay<?> getRoot(IJsonOverlay<V> overlay) {
        return ((AbstractJsonOverlay)overlay)._getRoot();
    }

    public <Model> Model getModel() {
        if (this.overlay instanceof IModelPart) {
            AbstractJsonOverlay<?> root = this.overlay._getRoot();
            return (Model)root;
        }
        return null;
    }

    public static <Model, V> Model getModel(IJsonOverlay<V> overlay) {
        return new Overlay<V>(overlay).getModel();
    }

    public String getPathFromRoot() {
        return this.overlay._getPathFromRoot();
    }

    public static <V> String getPathFromFromRoot(IJsonOverlay<V> overlay) {
        return ((AbstractJsonOverlay)overlay)._getPathFromRoot();
    }

    public URL getJsonReference() {
        return this.overlay._getJsonReference();
    }

    public static <V> URL getJsonReference(IJsonOverlay<V> overlay) {
        return ((AbstractJsonOverlay)overlay)._getJsonReference();
    }

    public List<String> getPropertyNames() {
        if (this.overlay instanceof PropertiesOverlay) {
            return ((PropertiesOverlay)this.overlay).getPropertyNames();
        }
        return null;
    }

    public static <V> List<String> getPropertyNames(IJsonOverlay<V> overlay) {
        return new Overlay<V>(overlay).getPropertyNames();
    }

    public boolean isReference(String key) {
        return this.getReference(key) != null;
    }

    public static <V> boolean isReference(IJsonOverlay<V> overlay, String key) {
        return new Overlay<V>(overlay).isReference(key);
    }

    public boolean isReference(int index) {
        return this.getReference(index) != null;
    }

    public static <V> boolean isReference(IJsonOverlay<V> overlay, int index) {
        return new Overlay<V>(overlay).getReference(index) != null;
    }

    public Reference getReference(String key) {
        if (this.overlay instanceof PropertiesOverlay) {
            return this.getPropertyReference(key);
        }
        if (this.overlay instanceof MapOverlay) {
            return this.getMapReference(key);
        }
        return null;
    }

    public static <V> Reference getReference(IJsonOverlay<V> overlay, String key) {
        return new Overlay<V>(overlay).getReference(key);
    }

    public Reference getReference(int index) {
        if (this.overlay instanceof ListOverlay) {
            return this.getListReference(index);
        }
        return null;
    }

    public static <V> Reference getReference(IJsonOverlay<V> overlay, int index) {
        return new Overlay<V>(overlay).getReference(index);
    }

    private Reference getPropertyReference(String name) {
        PropertiesOverlay propsOverlay = (PropertiesOverlay)this.overlay;
        return propsOverlay.getReference(name);
    }

    private Reference getMapReference(String key) {
        MapOverlay mapOverlay = (MapOverlay)this.overlay;
        return mapOverlay.getReference(key);
    }

    private Reference getListReference(int index) {
        ListOverlay listOverlay = (ListOverlay)this.overlay;
        return listOverlay.getReference(index);
    }
}

