/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.jsonoverlay;

import com.fasterxml.jackson.databind.JsonNode;
import com.reprezen.jsonoverlay.JsonOverlay;
import com.reprezen.jsonoverlay.OverlayFactory;
import com.reprezen.jsonoverlay.ReferenceRegistry;
import com.reprezen.jsonoverlay.ScalarOverlay;
import com.reprezen.jsonoverlay.SerializationOptions;

public class IntegerOverlay
extends ScalarOverlay<Integer> {
    public static OverlayFactory<Integer> factory = new OverlayFactory<Integer>(){

        @Override
        protected Class<IntegerOverlay> getOverlayClass() {
            return IntegerOverlay.class;
        }

        public IntegerOverlay _create(Integer value, JsonOverlay<?> parent, ReferenceRegistry refReg) {
            return new IntegerOverlay(value, parent, refReg);
        }

        public IntegerOverlay _create(JsonNode json, JsonOverlay<?> parent, ReferenceRegistry refReg) {
            return new IntegerOverlay(json, parent, refReg);
        }
    };

    private IntegerOverlay(Integer value, JsonOverlay<?> parent, ReferenceRegistry refReg) {
        super(value, parent, refReg);
    }

    private IntegerOverlay(JsonNode json, JsonOverlay<?> parent, ReferenceRegistry refReg) {
        super(json, parent, refReg);
    }

    @Override
    public Integer fromJson(JsonNode json) {
        return json.isInt() ? Integer.valueOf(json.intValue()) : null;
    }

    @Override
    public JsonNode _toJsonInternal(SerializationOptions options) {
        return this.value != null ? IntegerOverlay.jsonScalar((Integer)this.value) : IntegerOverlay.jsonMissing();
    }
}

