/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.val3;

import com.google.inject.Inject;
import com.reprezen.jsonoverlay.IJsonOverlay;
import com.reprezen.jsonoverlay.Overlay;
import com.reprezen.jsonoverlay.PropertiesOverlay;
import com.reprezen.kaizen.oasparser.model3.MediaType;
import com.reprezen.kaizen.oasparser.model3.Parameter;
import com.reprezen.kaizen.oasparser.model3.Path;
import com.reprezen.kaizen.oasparser.model3.Schema;
import com.reprezen.kaizen.oasparser.val.Messages;
import com.reprezen.kaizen.oasparser.val.ObjectValidatorBase;
import com.reprezen.kaizen.oasparser.val.ValidationResults;
import com.reprezen.kaizen.oasparser.val.Validator;
import com.reprezen.kaizen.oasparser.val3.Regexes;

public class ParameterValidator
extends ObjectValidatorBase<Parameter> {
    @Inject
    private Validator<Schema> schemaValidator;
    @Inject
    private Validator<MediaType> mediaTypeValidator;

    @Override
    public void validateObject(Parameter parameter, ValidationResults results) {
        this.validateString(parameter.getName(), results, true, "name");
        this.validateString(parameter.getIn(), results, true, Regexes.PARAM_IN_REGEX, "in");
        this.checkPathParam(parameter, results);
        this.checkRequired(parameter, results);
        this.validateString(parameter.getStyle(), results, false, Regexes.STYLE_REGEX, "style");
        this.checkAllowReserved(parameter, results);
        this.validateField(parameter.getSchema(false), results, false, "schema", this.schemaValidator);
        this.validateMap(parameter.getContentMediaTypes(), results, false, "content", Regexes.NOEXT_REGEX, this.mediaTypeValidator);
        this.validateExtensions(parameter.getExtensions(), results);
    }

    private void checkPathParam(Parameter parameter, ValidationResults results) {
        if (parameter.getIn() != null && parameter.getIn().equals("path") && parameter.getName() != null) {
            String path = this.getPathString(parameter);
            if (path != null) {
                if (!path.matches(".*/\\{" + parameter.getName() + "\\}(/.*)?")) {
                    results.addError(Messages.m.msg("MissingPathTplt|No template for path parameter in path string", parameter.getName(), path), "name");
                }
            } else {
                results.addWarning(Messages.m.msg("NoPath|Could not locate path for parameter", parameter.getName(), parameter.getIn()));
            }
        }
    }

    private void checkRequired(Parameter parameter, ValidationResults results) {
        if ("path".equals(parameter.getIn()) && parameter.getRequired() != Boolean.TRUE) {
            results.addError(Messages.m.msg("PathParamReq|Path param must have 'required' property set true", parameter.getName()), "required");
        }
    }

    private void checkAllowReserved(Parameter parameter, ValidationResults results) {
        if (parameter.isAllowReserved() && !"query".equals(parameter.getIn())) {
            results.addWarning(Messages.m.msg("NonQryAllowRsvd|AllowReserved is ignored for non-query parameter", parameter.getName(), parameter.getIn()), "allowReserved");
        }
    }

    private String getPathString(Parameter parameter) {
        PropertiesOverlay parent = Overlay.getParentPropertiesOverlay((IJsonOverlay)parameter);
        while (parent != null && !(parent instanceof Path)) {
            parent = Overlay.of((IJsonOverlay)parent).getParentPropertiesOverlay();
        }
        return parent != null && parent instanceof Path ? Overlay.getPathInParent((IJsonOverlay)parent) : null;
    }
}

