/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.jsonoverlay;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.reprezen.jsonoverlay.AbstractJsonOverlay;
import com.reprezen.jsonoverlay.JsonOverlay;
import com.reprezen.jsonoverlay.JsonPath;
import com.reprezen.jsonoverlay.MapOverlay;
import com.reprezen.jsonoverlay.NoOverlay;
import com.reprezen.jsonoverlay.OverlayFactory;
import com.reprezen.jsonoverlay.PropertiesOverlay;
import com.reprezen.jsonoverlay.Reference;
import com.reprezen.jsonoverlay.ReferenceRegistry;
import com.reprezen.jsonoverlay.SerializationOptions;
import java.net.URL;

public class ChildOverlay<V>
extends AbstractJsonOverlay<V> {
    private JsonPath path;
    protected JsonOverlay<V> overlay;
    private JsonOverlay<?> parent;
    private Reference reference = null;
    protected OverlayFactory<V> factory;
    private static final SerializationOptions emptyOptions = new SerializationOptions(new SerializationOptions.Option[0]);

    public ChildOverlay(String path, V value, JsonOverlay<?> parent, OverlayFactory<V> factory, ReferenceRegistry refReg) {
        this.path = new JsonPath(path);
        this.parent = parent;
        this.factory = factory;
        this.overlay = factory.create(value, parent, refReg, null);
    }

    public ChildOverlay(String path, JsonNode json, JsonOverlay<?> parent, OverlayFactory<V> factory, ReferenceRegistry refReg) {
        this(path, json, parent, factory, refReg, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ChildOverlay(String path, JsonNode json, JsonOverlay<?> parent, OverlayFactory<V> factory, ReferenceRegistry refReg, boolean sharedOk) {
        this.path = new JsonPath(path);
        this.parent = parent;
        this.factory = factory;
        if (Reference.isReferenceNode(json)) {
            this.reference = refReg.getRef(json);
            JsonNode resolved = this.reference.resolve();
            if (this.reference.isValid()) {
                if (sharedOk && refReg.hasOverlay(resolved)) {
                    JsonOverlay castOverlay;
                    AbstractJsonOverlay<?> overlay = refReg.getOverlay(resolved);
                    if (!factory.isCompatible(overlay)) throw new IllegalStateException("Referenced object is not compatible with referencing site");
                    this.overlay = castOverlay = (JsonOverlay)overlay;
                    return;
                } else {
                    if (factory instanceof MapOverlay.MapOverlayFactory) {
                        JsonOverlay castOverlay;
                        MapOverlay.MapOverlayFactory mapFactory = (MapOverlay.MapOverlayFactory)factory;
                        this.overlay = castOverlay = (JsonOverlay)mapFactory.create(resolved, null, !sharedOk, refReg, this.reference);
                    } else {
                        this.overlay = (JsonOverlay)factory.create(resolved, (JsonOverlay<?>)null, refReg, this.reference);
                    }
                    if (!sharedOk) return;
                    refReg.setOverlay(resolved, this.overlay);
                }
                return;
            } else {
                this.overlay = new NoOverlay<JsonNode>(json, parent, refReg);
            }
            return;
        } else {
            this.overlay = (JsonOverlay)factory.create(json, parent, this.isPartial(), refReg);
        }
    }

    protected boolean isPartial() {
        return false;
    }

    protected boolean matchesPath(JsonPointer path) {
        return this.path.matchesPath(path);
    }

    protected JsonPointer tailPath(JsonPointer path) {
        return this.path.tailPath(path);
    }

    @Override
    public boolean _isPresent() {
        return this.overlay._isPresent();
    }

    @Override
    public V _get() {
        return this.overlay._get();
    }

    public V _get(boolean complete) {
        if (this.overlay instanceof PropertiesOverlay) {
            return ((PropertiesOverlay)this.overlay)._get(complete);
        }
        return this.overlay._get();
    }

    @Override
    public AbstractJsonOverlay<?> _find(JsonPointer path) {
        return this.overlay._find(path);
    }

    @Override
    public AbstractJsonOverlay<?> _find(String path) {
        return this.overlay._find(path);
    }

    @Override
    public void _set(V value) {
        this.overlay._set(value);
    }

    @Override
    public AbstractJsonOverlay<?> _getParent() {
        return this.parent;
    }

    @Override
    public String _getPathInParent() {
        return this.overlay._getPathInParent();
    }

    @Override
    public AbstractJsonOverlay<?> _getRoot() {
        return this.parent != null ? this.parent._getParent() : this.overlay._getRoot();
    }

    @Override
    public JsonNode _toJson() {
        return this._toJson(emptyOptions);
    }

    @Override
    public JsonNode _toJson(SerializationOptions.Option ... options) {
        return this._toJson(new SerializationOptions(options));
    }

    @Override
    public JsonNode _toJson(SerializationOptions options) {
        if (this.isReference() && (!options.isFollowRefs() || this.getReference().isInvalid())) {
            ObjectNode obj = JsonOverlay.jsonObject();
            obj.put("$ref", this.reference.getRefString());
            return obj;
        }
        return this.overlay != null ? this.overlay._toJsonInternal(options) : JsonOverlay.jsonNull();
    }

    @Override
    public boolean _isElaborated() {
        return this.overlay._isElaborated();
    }

    public JsonPath getPath() {
        return this.path;
    }

    public boolean isReference() {
        return this.reference != null;
    }

    public Reference getReference() {
        return this.reference;
    }

    public JsonOverlay<V> getOverlay() {
        return this.overlay;
    }

    @Override
    public String _getPathFromRoot() {
        return this.overlay._getPathFromRoot();
    }

    @Override
    public URL _getJsonReference() {
        return this.overlay._getJsonReference();
    }

    public String toString() {
        String refString = this.reference != null ? String.format("<%s>", this.reference.getRefString()) : "";
        return String.format("Child@%s%s: %s", this.path, refString, this.overlay);
    }
}

