/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.jsonoverlay;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Maps;
import com.reprezen.jsonoverlay.AbstractJsonOverlay;
import com.reprezen.jsonoverlay.Reference;
import com.reprezen.jsonoverlay.ResolutionBase;
import com.reprezen.jsonoverlay.ResolutionException;
import java.util.Collection;
import java.util.Map;

public class ReferenceRegistry {
    private Map<String, Reference> references = Maps.newHashMap();
    private Map<JsonNode, AbstractJsonOverlay<?>> overlays = Maps.newIdentityHashMap();

    public Collection<Reference> getAllReferences() {
        return this.references.values();
    }

    public String registerRef(JsonNode refStringNode, ResolutionBase base, boolean resolve) {
        return this.getRef(refStringNode, base, resolve).getKey();
    }

    public String registerRef(String refString, ResolutionBase base, boolean resolve) {
        return this.getRef(refString, base, resolve).getKey();
    }

    public Reference getRef(String key) {
        return this.references.get(key);
    }

    public Reference getRef(JsonNode refNode) {
        if (refNode.isObject() && refNode.has("$ref") && refNode.has("key")) {
            return this.getRef(refNode.get("key").textValue());
        }
        return null;
    }

    public Reference getRef(JsonNode refStringNode, ResolutionBase base, boolean resolve) {
        if (refStringNode.isTextual()) {
            return this.getRef(refStringNode.textValue(), base, resolve);
        }
        String badRefString = refStringNode.toString();
        Reference ref = new Reference(badRefString, base, new ResolutionException("Non-text $ref property value in JSON reference node"), this);
        String key = ref.getKey();
        if (!this.references.containsKey(key)) {
            this.references.put(key, ref);
        }
        return this.references.get(key);
    }

    public Reference getRef(String refString, ResolutionBase base, boolean resolve) {
        try {
            if (base.isInvalid()) {
                throw new ResolutionException("Invalid base for reference resolution", base.getError());
            }
            String comprehendedRef = base.comprehend(refString);
            if (!this.references.containsKey(comprehendedRef)) {
                this.references.put(comprehendedRef, new Reference(refString, comprehendedRef, base, this));
            }
            Reference ref = this.references.get(comprehendedRef);
            if (resolve) {
                ref.resolve(false);
            }
            return ref;
        }
        catch (ResolutionException e) {
            Reference ref = new Reference(refString, base, e, this);
            this.references.put(refString, ref);
            return ref;
        }
    }

    public AbstractJsonOverlay<?> getOverlay(JsonNode node) {
        return this.overlays.get(node);
    }

    public boolean hasOverlay(JsonNode node) {
        return !node.isMissingNode() && this.overlays.containsKey(node);
    }

    public void setOverlay(JsonNode node, AbstractJsonOverlay<?> overlay) {
        if (!node.isMissingNode() && overlay != null) {
            this.overlays.put(node, overlay);
        }
    }
}

