/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.val;

import com.google.inject.Inject;
import com.reprezen.jsonoverlay.PropertiesOverlay;
import com.reprezen.kaizen.oasparser.val.ImplValidator;
import com.reprezen.kaizen.oasparser.val.ValidationResults;
import com.reprezen.kaizen.oasparser.val.ValidatorBase;
import java.util.IdentityHashMap;
import java.util.Map;

public abstract class ObjectValidatorBase<T>
extends ValidatorBase<T> {
    @Inject(optional=true)
    private ImplValidator<T> implValidator;
    protected static ThreadLocal<ValidationVisits> validationVisits = new ThreadLocal();

    public abstract void validateObject(T var1, ValidationResults var2);

    protected static boolean visit(Object obj) {
        if (validationVisits.get() == null) {
            validationVisits.set(new ValidationVisits());
        }
        return validationVisits.get().visit(obj);
    }

    @Override
    public void validate(T value, ValidationResults results) {
        PropertiesOverlay propValue;
        if (!ObjectValidatorBase.visit(value) && (propValue = (PropertiesOverlay)value)._isElaborated()) {
            this.validateObject(value, results);
            if (this.implValidator != null) {
                this.implValidator.validateImpl(value, results);
            }
        }
    }

    protected static class ValidationVisits {
        private Map<Object, Object> visits = new IdentityHashMap<Object, Object>();

        protected ValidationVisits() {
        }

        public boolean visit(Object obj) {
            if (this.visits.containsKey(obj)) {
                return false;
            }
            this.visits.put(obj, obj);
            return true;
        }
    }
}

