/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.wfs30;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opengis.cite.wfs30.CommonFixture;
import org.opengis.cite.wfs30.SuiteAttribute;
import org.opengis.cite.wfs30.conformance.RequirementClass;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;

public class CommonDataFixture
extends CommonFixture {
    private static final int DEFAULT_NUMBER_OF_COLLECTIONS = 3;
    private List<RequirementClass> requirementClasses;
    protected int noOfCollections = 3;

    @BeforeClass
    public void requirementClasses(ITestContext testContext) {
        this.requirementClasses = (List)testContext.getSuite().getAttribute(SuiteAttribute.REQUIREMENTCLASSES.getName());
    }

    @BeforeClass
    public void noOfCollections(ITestContext testContext) {
        Object noOfCollections = testContext.getSuite().getAttribute(SuiteAttribute.NO_OF_COLLECTIONS.getName());
        if (noOfCollections != null) {
            this.noOfCollections = (Integer)noOfCollections;
        }
    }

    protected List<String> createListOfMediaTypesToSupportForOtherResources(Map<String, Object> linkToSelf) {
        if (this.requirementClasses == null) {
            throw new SkipException("No requirement classes described in  resource /conformance available");
        }
        ArrayList<String> mediaTypesToSupport = new ArrayList<String>();
        for (RequirementClass requirementClass : this.requirementClasses) {
            if (!requirementClass.hasMediaTypeForOtherResources()) continue;
            mediaTypesToSupport.add(requirementClass.getMediaTypeOtherResources());
        }
        if (linkToSelf != null) {
            mediaTypesToSupport.remove(linkToSelf.get("type"));
        }
        return mediaTypesToSupport;
    }

    protected List<String> createListOfMediaTypesToSupportForFeatureCollectionsAndFeatures() {
        if (this.requirementClasses == null) {
            throw new SkipException("No requirement classes described in  resource /conformance available");
        }
        ArrayList<String> mediaTypesToSupport = new ArrayList<String>();
        for (RequirementClass requirementClass : this.requirementClasses) {
            if (!requirementClass.hasMediaTypeForFeaturesAndCollections()) continue;
            mediaTypesToSupport.add(requirementClass.getMediaTypeFeaturesAndCollections());
        }
        return mediaTypesToSupport;
    }

    protected List<String> createListOfMediaTypesToSupportForFeatureCollectionsAndFeatures(Map<String, Object> linkToSelf) {
        List<String> mediaTypesToSupport = this.createListOfMediaTypesToSupportForFeatureCollectionsAndFeatures();
        if (linkToSelf != null) {
            mediaTypesToSupport.remove(linkToSelf.get("type"));
        }
        return mediaTypesToSupport;
    }
}

