/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.wfs30.collections;

import com.reprezen.kaizen.oasparser.model3.OpenApi3;
import io.restassured.http.ContentType;
import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opengis.cite.wfs30.CommonDataFixture;
import org.opengis.cite.wfs30.EtsAssert;
import org.opengis.cite.wfs30.SuiteAttribute;
import org.opengis.cite.wfs30.openapi3.OpenApiUtils;
import org.opengis.cite.wfs30.openapi3.TestPoint;
import org.opengis.cite.wfs30.openapi3.UriBuilder;
import org.opengis.cite.wfs30.util.JsonUtils;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class FeatureCollectionsMetadataOperation
extends CommonDataFixture {
    private final Map<TestPoint, Response> testPointAndResponses = new HashMap<TestPoint, Response>();
    private final Map<TestPoint, List<Map<String, Object>>> testPointAndCollections = new HashMap<TestPoint, List<Map<String, Object>>>();
    private OpenApi3 apiModel;
    private Object[][] testPointsData;

    @DataProvider(name="collectionsUris")
    public Object[][] collectionsUris(ITestContext testContext) {
        if (this.testPointsData == null) {
            OpenApi3 apiModel = (OpenApi3)testContext.getSuite().getAttribute(SuiteAttribute.API_MODEL.getName());
            List<TestPoint> testPoints = OpenApiUtils.retrieveTestPointsForCollectionsMetadata(apiModel);
            this.testPointsData = new Object[][]{testPoints.toArray()};
        }
        return this.testPointsData;
    }

    @DataProvider(name="collections")
    public Object[][] collections(ITestContext testContext) {
        int length = 0;
        for (List<Map<String, Object>> collections : this.testPointAndCollections.values()) {
            length += collections.size();
        }
        Object[][] objects = new Object[length][];
        int i = 0;
        for (Map.Entry<TestPoint, List<Map<String, Object>>> testPointAndCollection : this.testPointAndCollections.entrySet()) {
            for (Map<String, Object> collection : testPointAndCollection.getValue()) {
                objects[i++] = new Object[]{testPointAndCollection.getKey(), collection};
            }
        }
        return objects;
    }

    @BeforeClass
    public void openApiDocument(ITestContext testContext) {
        this.apiModel = (OpenApi3)testContext.getSuite().getAttribute(SuiteAttribute.API_MODEL.getName());
    }

    @AfterClass
    public void storeCollectionsInTestContext(ITestContext testContext) {
        ArrayList<Map<String, Object>> collections = new ArrayList<Map<String, Object>>();
        for (List<Map<String, Object>> testPointAndCollection : this.testPointAndCollections.values()) {
            collections.addAll(testPointAndCollection);
        }
        testContext.getSuite().setAttribute(SuiteAttribute.COLLECTIONS.getName(), collections);
    }

    @Test(description="Implements A.4.4.4. Validate the Feature Collections Metadata Operation (Requirement 9, 10)", groups={"collections"}, dataProvider="collectionsUris", dependsOnGroups={"apidefinition", "conformance"})
    public void validateFeatureCollectionsMetadataOperation(TestPoint testPoint) {
        String testPointUri = new UriBuilder(testPoint).buildUrl();
        Response response = (Response)this.init().baseUri(testPointUri).accept(ContentType.JSON).when().request(Method.GET);
        ((ValidatableResponse)response.then()).statusCode(200);
        this.testPointAndResponses.put(testPoint, response);
    }

    @Test(description="Implements A.4.4.5. Validate the Feature Collections Metadata Operation Response (Requirement 11)", dataProvider="collectionsUris", dependsOnMethods={"validateFeatureCollectionsMetadataOperation"}, alwaysRun=true)
    public void validateFeatureCollectionsMetadataOperationResponse_Links(TestPoint testPoint) {
        Response response = this.testPointAndResponses.get(testPoint);
        if (response == null) {
            throw new SkipException("Could not find a response for test point " + testPoint);
        }
        JsonPath jsonPath = response.jsonPath();
        List links = jsonPath.getList("links");
        Map<String, Object> linkToSelf = JsonUtils.findLinkByRel(links, "self");
        Assert.assertNotNull(linkToSelf, (String)"Feature Collection Metadata document must include a link for itself");
        EtsAssert.assertTrue(JsonUtils.linkIncludesRelAndType(linkToSelf), "Link to itself must include a rel and type parameter");
        List<String> mediaTypesToSupport = this.createListOfMediaTypesToSupportForOtherResources(linkToSelf);
        List<Map<String, Object>> alternateLinks = JsonUtils.findLinksWithSupportedMediaTypeByRel(links, mediaTypesToSupport, "alternate");
        List<String> typesWithoutLink = JsonUtils.findUnsupportedTypes(alternateLinks, mediaTypesToSupport);
        EtsAssert.assertTrue(typesWithoutLink.isEmpty(), "Feature Collection Metadata document must include links for alternate encodings. Missing links for types " + typesWithoutLink);
        List<String> linksWithoutRelOrType = JsonUtils.findLinksWithoutRelOrType(alternateLinks);
        EtsAssert.assertTrue(linksWithoutRelOrType.isEmpty(), "Links for alternate encodings must include a rel and type parameter. Missing for links " + linksWithoutRelOrType);
    }

    @Test(description="Implements A.4.4.5. Validate the Feature Collections Metadata Operation Response (Requirement 12)", groups={"collections"}, dataProvider="collectionsUris", dependsOnMethods={"validateFeatureCollectionsMetadataOperation"}, alwaysRun=true)
    public void validateFeatureCollectionsMetadataOperationResponse_Collections(TestPoint testPoint) {
        Response response = this.testPointAndResponses.get(testPoint);
        if (response == null) {
            throw new SkipException("Could not find a response for test point " + testPoint);
        }
        JsonPath jsonPath = response.jsonPath();
        List collections = jsonPath.getList("collections");
        this.testPointAndCollections.put(testPoint, this.createCollectionsMap(collections));
    }

    @Test(description="Implements A.4.4.6. Validate a Collections Metadata document (Requirement 13)", groups={"collections"}, dataProvider="collections", dependsOnMethods={"validateFeatureCollectionsMetadataOperationResponse_Collections"}, alwaysRun=true)
    public void validateCollectionsMetadataDocument_Links(TestPoint testPoint, Map<String, Object> collection) {
        String collectionName = (String)collection.get("name");
        List<String> mediaTypesToSupport = this.createListOfMediaTypesToSupportForFeatureCollectionsAndFeatures();
        List links = (List)collection.get("links");
        List<Map<String, Object>> items = JsonUtils.findLinksWithSupportedMediaTypeByRel(links, mediaTypesToSupport, "item");
        List<String> typesWithoutLink = JsonUtils.findUnsupportedTypes(items, mediaTypesToSupport);
        EtsAssert.assertTrue(typesWithoutLink.isEmpty(), "Collections Metadata document for collection with name " + collectionName + " must include links with relation 'item' for each supported encodings. Missing links for types " + String.join((CharSequence)", ", typesWithoutLink));
        List<String> linksWithoutRelOrType = JsonUtils.findLinksWithoutRelOrType(items);
        EtsAssert.assertTrue(linksWithoutRelOrType.isEmpty(), "Links with relation 'item' for encodings must include a rel and type parameter. Missing for links " + String.join((CharSequence)", ", linksWithoutRelOrType));
    }

    @Test(description="Implements A.4.4.6. Validate a Collections Metadata document (Requirement 14)", groups={"collections"}, dataProvider="collections", dependsOnMethods={"validateFeatureCollectionsMetadataOperationResponse_Collections"}, alwaysRun=true)
    public void validateCollectionsMetadataDocument_Extent(TestPoint testPoint, Map<String, Object> collection) {
    }

    @Test(description="Implements A.4.4.7. Validate the Feature Collection Metadata Operation (Requirement 15) and A.4.4.8. Validate the Feature Collection Metadata Operation Response (Requirement 16)", groups={"collections"}, dataProvider="collections", dependsOnMethods={"validateFeatureCollectionsMetadataOperationResponse_Collections"}, alwaysRun=true)
    public void validateTheFeatureCollectionMetadataOperationAndResponse(TestPoint testPoint, Map<String, Object> collection) {
        String collectionName = (String)collection.get("name");
        List<TestPoint> testPointsForNamedCollection = OpenApiUtils.retrieveTestPointsForCollectionMetadata(this.apiModel, collectionName);
        if (testPointsForNamedCollection.isEmpty()) {
            throw new SkipException("Could not find collection with name " + collectionName + " in the OpenAPI document");
        }
        TestPoint testPointCollectionMetadata = testPointsForNamedCollection.get(0);
        Response response = this.validateTheFeatureCollectionMetadataOperationAndResponse(testPointCollectionMetadata, collectionName);
        this.validateFeatureCollectionMetadataOperationResponse(response, collection);
    }

    private Response validateTheFeatureCollectionMetadataOperationAndResponse(TestPoint testPoint, String collectionName) {
        String testPointUri = new UriBuilder(testPoint).collectionName(collectionName).buildUrl();
        Response response = (Response)this.init().baseUri(testPointUri).accept(ContentType.JSON).when().request(Method.GET);
        ((ValidatableResponse)response.then()).statusCode(200);
        return response;
    }

    private void validateFeatureCollectionMetadataOperationResponse(Response response, Map<String, Object> collection) {
        JsonPath jsonPath = response.jsonPath();
        Assert.assertEquals(collection, (Map)((Map)jsonPath.get()));
    }

    private List<Map<String, Object>> createCollectionsMap(List<Object> collections) {
        ArrayList<Map<String, Object>> collectionsMap = new ArrayList<Map<String, Object>>();
        for (Object collection : collections) {
            collectionsMap.add((Map)collection);
            if (this.noOfCollections <= 0 || collectionsMap.size() < this.noOfCollections) continue;
            return collectionsMap;
        }
        return collectionsMap;
    }
}

