/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.spi.jaxrs.resources.wmsclient;

import com.occamlab.te.SetupOptions;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Stack;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Path(value="suiteMap")
@Produces(value={"application/json"})
public class TestMapResources {
    private static final String TE_BASE = "TE_BASE";

    @GET
    public String handleGet(@QueryParam(value="userID") String userId, @QueryParam(value="sessionID") String sessionID) throws IOException, JSONException, ParserConfigurationException, SAXException {
        File basePath = SetupOptions.getBaseConfigDirectory();
        String pathAddress = basePath + "/users/" + userId + "/" + sessionID + "/test_data";
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document mapLayerDocument = docBuilder.parse(new File(pathAddress + "/Get-Map-Layer.xml"));
        NodeList listOfPersons = mapLayerDocument.getElementsByTagName("value");
        Stack<String> mapLayerTestDetail = new Stack<String>();
        if (null != listOfPersons && listOfPersons.getLength() > 0) {
            for (int index = 0; index < listOfPersons.getLength(); ++index) {
                mapLayerTestDetail.push(listOfPersons.item(index).getFirstChild().toString().split(" ")[1].split("]")[0]);
            }
        }
        JSONObject jsonObj = new JSONObject();
        JSONArray jsonArr = new JSONArray();
        while (!mapLayerTestDetail.isEmpty()) {
            JSONObject mapLayerTestObject = new JSONObject();
            mapLayerTestObject.put("Name", mapLayerTestDetail.peek());
            mapLayerTestDetail.pop();
            jsonArr.put((Object)mapLayerTestObject);
        }
        jsonObj.put("TEST", (Object)jsonArr);
        return jsonObj.toString();
    }

    @POST
    @Consumes(value={"text/plain"})
    public void handlepost(@QueryParam(value="userID") String userId, @QueryParam(value="sessionID") String sessionID, String data) throws ParserConfigurationException, TransformerException, TransformerConfigurationException, FileNotFoundException, IOException {
        File basePath = SetupOptions.getBaseConfigDirectory();
        String pathAddress = basePath + "/users/" + userId + "/" + sessionID + "/test_data";
        File fulePath = new File(pathAddress, "/finalResult.txt");
        OutputStreamWriter writerBefore = new OutputStreamWriter((OutputStream)new FileOutputStream(fulePath, true), "UTF-8");
        try (BufferedWriter fbwBefore = new BufferedWriter(writerBefore);){
            fbwBefore.write(data);
            fbwBefore.newLine();
            fbwBefore.close();
        }
    }
}

