/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.spi.jaxrs.resources.wmsclient;

import com.occamlab.te.SetupOptions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Stack;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FilenameUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Path(value="suiteJson")
@Produces(value={"application/json"})
public class StoreRunResources {
    private static final String TE_BASE = "TE_BASE";

    @POST
    @Consumes(value={"text/plain"})
    public String handleGet(@QueryParam(value="userID") String userId, @QueryParam(value="sessionID") String sessionID, String testData) throws IOException, JSONException {
        JSONObject jsonObjTestDetail = new JSONObject();
        JSONArray jsonArrTestDetail = new JSONArray();
        File basePath = SetupOptions.getBaseConfigDirectory();
        String pathAddress = basePath + File.separator + "users" + File.separator + userId + File.separator + sessionID + File.separator + "test_data";
        pathAddress = FilenameUtils.normalize((String)pathAddress);
        int testCount = 1;
        int runTestId = 1;
        Stack<String> runTestStack = new Stack<String>();
        Stack traverseTestStack = new Stack();
        Stack<Integer> outputTestStack = new Stack<Integer>();
        try {
            int index;
            String lineReader;
            FileInputStream inputStreamDirectory = new FileInputStream(new File(pathAddress + File.separator + "test_result.txt"));
            BufferedReader dataReader = new BufferedReader(new InputStreamReader(inputStreamDirectory));
            while ((lineReader = dataReader.readLine()) != null) {
                JSONObject subTestLayerJsonObject = new JSONObject(lineReader);
                String jsonResult = (String)subTestLayerJsonObject.get("Result");
                if ("".equals(jsonResult)) {
                    runTestStack.push(testCount + " " + subTestLayerJsonObject.get("Name"));
                    ++testCount;
                    continue;
                }
                while (runTestStack.peek().toString().contains("Passed") || runTestStack.peek().toString().contains("Failed")) {
                    traverseTestStack.push(runTestStack.peek());
                    runTestStack.pop();
                }
                runTestStack.pop();
                runTestStack.push(--testCount + "  Name :" + subTestLayerJsonObject.get("Name") + "  Result :" + subTestLayerJsonObject.get("Result") + "  Time :" + subTestLayerJsonObject.get("Time"));
                while (!traverseTestStack.isEmpty()) {
                    runTestStack.push((String)traverseTestStack.peek());
                    traverseTestStack.pop();
                }
            }
            int testCounter = 1;
            int testParentID = 1;
            int testSpacing = 1;
            try {
                if (null != runTestStack && !runTestStack.isEmpty()) {
                    for (index = 0; index < runTestStack.size(); ++index) {
                        Object object = runTestStack.get(index);
                        testSpacing = Integer.parseInt(object.toString().split(" ")[0]);
                        if (testCounter < testSpacing) {
                            outputTestStack.push(runTestId);
                            testCounter = testSpacing;
                        }
                        if (testCounter > testSpacing) {
                            while (testCounter - testSpacing > 0) {
                                if (!outputTestStack.isEmpty()) {
                                    outputTestStack.pop();
                                }
                                --testCounter;
                            }
                        }
                        if (testSpacing == 1) {
                            testParentID = 0;
                        }
                        if (!outputTestStack.isEmpty()) {
                            testParentID = (Integer)outputTestStack.peek() - 1;
                        }
                        JSONObject objectEachTest = new JSONObject();
                        objectEachTest.put("Indent", testSpacing);
                        objectEachTest.put("Name", (Object)object.toString().split(" ")[3].substring(1));
                        objectEachTest.put("Result", (Object)object.toString().split(" ")[6].substring(1));
                        objectEachTest.put("Time", (Object)object.toString().split(" ")[9].substring(1));
                        objectEachTest.put("ObjectID", runTestId);
                        objectEachTest.put("ParentID", testParentID);
                        jsonArrTestDetail.put((Object)objectEachTest);
                        ++runTestId;
                    }
                }
            }
            catch (JSONException e) {
                JSONObject obj = new JSONObject();
                obj.put("Result", (Object)e.toString());
            }
            if (null != jsonArrTestDetail && jsonArrTestDetail.length() > 0) {
                for (index = 1; index < jsonArrTestDetail.length(); ++index) {
                    JSONObject data = jsonArrTestDetail.getJSONObject(index);
                    if (!data.getString("Result").equals("Failed")) continue;
                    StoreRunResources test = new StoreRunResources();
                    test.update(data.getInt("ParentID"), jsonArrTestDetail);
                }
            }
            if (null != jsonArrTestDetail && jsonArrTestDetail.length() > 0) {
                for (index = 0; index < jsonArrTestDetail.length(); ++index) {
                    JSONObject objec = jsonArrTestDetail.getJSONObject(index);
                    if (!"1".equals(objec.getString("Indent"))) continue;
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    factory.setNamespaceAware(true);
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document resultDocument = builder.newDocument();
                    Element execution = resultDocument.createElement("execution");
                    resultDocument.appendChild(execution);
                    DOMSource inputSource = new DOMSource(resultDocument);
                    JSONObject testName = new JSONObject(testData);
                    JSONArray testDetail = testName.getJSONArray("TestName");
                    if (null == testDetail || testDetail.length() <= 0) continue;
                    for (int i = 0; i < testDetail.length(); ++i) {
                        JSONObject test = testDetail.getJSONObject(i);
                        if (!objec.getString("Name").equals(test.getString("Name"))) continue;
                        String fileName = "Passed".equals(objec.getString("Result")) ? test.getString("File").split(".xml")[0] + "Pass.xml" : test.getString("File").split(".xml")[0] + "Fail.xml";
                        this.fileCreate(new File(FilenameUtils.normalize((String)pathAddress), FilenameUtils.normalize((String)fileName)), inputSource);
                    }
                }
            }
            jsonObjTestDetail.put("TEST", (Object)jsonArrTestDetail);
            return jsonObjTestDetail.toString();
        }
        catch (Exception e) {
            JSONObject obj = new JSONObject();
            obj.put("File", (Object)"File Not Present");
            return obj.toString();
        }
    }

    public void fileCreate(File file, Source input) throws TransformerConfigurationException, TransformerException, FileNotFoundException {
        TransformerFactory xformFactory = TransformerFactory.newInstance();
        Transformer idTransform = xformFactory.newTransformer();
        FileOutputStream report_logs = new FileOutputStream(file);
        StreamResult output = new StreamResult(report_logs);
        idTransform.transform(input, output);
    }

    public void update(int parentID, JSONArray jsonArr) throws JSONException {
        int parentId = parentID;
        while (jsonArr.getJSONObject(parentId - 1).getInt("ParentID") != 0) {
            jsonArr.getJSONObject(parentId - 1).put("Result", (Object)"Failed");
            parentId = jsonArr.getJSONObject(parentId - 1).getInt("ParentID");
        }
        if (jsonArr.getJSONObject(parentId - 1).getInt("ParentID") == 0) {
            jsonArr.getJSONObject(parentId - 1).put("Result", (Object)"Failed");
        }
    }
}

