/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.spi.jaxrs.resources.wmsclient;

import com.occamlab.te.SetupOptions;
import com.occamlab.te.spi.jaxrs.resources.wmsclient.WmsClientDomUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Stack;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FilenameUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Path(value="suiteMap")
@Produces(value={"application/json"})
public class TestMapResources {
    private static final String TE_BASE = "TE_BASE";

    @GET
    public String handleGet(@QueryParam(value="userID") String userId, @QueryParam(value="sessionID") String sessionID, @QueryParam(value="modifiedTime") String modifiedTime) throws IOException, JSONException, ParserConfigurationException, SAXException {
        File basePath = SetupOptions.getBaseConfigDirectory();
        String xmlFile = basePath + File.separator + "users" + File.separator + userId + File.separator + sessionID + File.separator + "test_data" + File.separator + File.separator + "Get-Map-Layer-New.xml";
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        String FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
        docBuilderFactory.setFeature(FEATURE, true);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document mapLayerDocument = docBuilder.parse(new File(xmlFile));
        JSONObject jsonObj = new JSONObject();
        NodeList listOfLayerValues = null;
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            String expression = "/Layers//value[not(@isProcessed)]";
            listOfLayerValues = (NodeList)xPath.compile(expression).evaluate(mapLayerDocument, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        Stack<String> mapLayerTestDetail = new Stack<String>();
        if (null != listOfLayerValues && listOfLayerValues.getLength() > 0) {
            for (int index = 0; index < listOfLayerValues.getLength(); ++index) {
                Node valueElement = listOfLayerValues.item(index);
                mapLayerTestDetail.push(valueElement.getFirstChild().toString().split(" ")[1].split("]")[0]);
                ((Element)valueElement).setAttribute("isProcessed", "true");
            }
        }
        WmsClientDomUtils.transformDocument(mapLayerDocument, new File(xmlFile));
        JSONArray jsonArr = new JSONArray();
        while (!mapLayerTestDetail.isEmpty()) {
            JSONObject mapLayerTestObject = new JSONObject();
            mapLayerTestObject.put("Name", mapLayerTestDetail.peek());
            mapLayerTestDetail.pop();
            jsonArr.put((Object)mapLayerTestObject);
        }
        jsonObj.put("TEST", (Object)jsonArr);
        return FilenameUtils.normalize((String)jsonObj.toString());
    }

    @POST
    @Consumes(value={"text/plain"})
    public void handlepost(@QueryParam(value="userID") String userId, @QueryParam(value="sessionID") String sessionID, String data) throws ParserConfigurationException, TransformerException, TransformerConfigurationException, FileNotFoundException, IOException {
        File basePath = SetupOptions.getBaseConfigDirectory();
        String pathAddress = basePath + File.separator + "users" + File.separator + userId + File.separator + sessionID + File.separator + "test_data";
        File fulePath = new File(FilenameUtils.normalize((String)pathAddress), File.separator + "finalResult.txt");
        OutputStreamWriter writerBefore = new OutputStreamWriter((OutputStream)new FileOutputStream(fulePath, true), "UTF-8");
        try (BufferedWriter fbwBefore = new BufferedWriter(writerBefore);){
            fbwBefore.write(data);
            fbwBefore.newLine();
            fbwBefore.close();
        }
    }
}

