/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.transformers;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.opengroup.ts.handlers.extensions.ogc.ResponseTransformer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ImageStats
extends ResponseTransformer {
    private static final Logger LOGR = Logger.getLogger(ImageStats.class.getName());
    private String TransformedDocument;

    private ImageStats(Object response, InputStream parameters) {
        super(response, "");
        this.TransformedDocument = this.transform(response, parameters);
    }

    public ImageStats() {
    }

    public ImageStats(Object response, String parameters) {
        super(response, parameters);
        ByteArrayInputStream stream = new ByteArrayInputStream(parameters.getBytes());
        this.TransformedDocument = this.transform(response, stream);
    }

    private static String HexString(int num, int digits) {
        String s = Integer.toHexString(num);
        if (digits > s.length()) {
            return "00000000".substring(0, digits - s.length()) + s;
        }
        return s;
    }

    @Override
    public String getTransformedDocument() {
        return this.TransformedDocument;
    }

    static void processBufferedImage(BufferedImage buffimage, NodeList propNodes) throws Exception {
        HashMap bandMap = new HashMap();
        for (int i = 0; i < propNodes.getLength(); ++i) {
            Node node = propNodes.item(i);
            if (node.getNodeName().equals("subimage")) {
                Element e = (Element)node;
                int x = Integer.parseInt(e.getAttribute("x"));
                int y = Integer.parseInt(e.getAttribute("y"));
                int w = Integer.parseInt(e.getAttribute("width"));
                int h = Integer.parseInt(e.getAttribute("height"));
                ImageStats.processBufferedImage(buffimage.getSubimage(x, y, w, h), e.getChildNodes());
                continue;
            }
            if (node.getNodeName().equals("checksum")) {
                CRC32 checksum = new CRC32();
                WritableRaster raster = buffimage.getRaster();
                DataBufferByte buffer = (DataBufferByte)raster.getDataBuffer();
                int numbanks = buffer.getNumBanks();
                for (int j = 0; j < numbanks; ++j) {
                    checksum.update(buffer.getData(j));
                }
                Document doc = node.getOwnerDocument();
                node.appendChild(doc.createTextNode(Long.toString(checksum.getValue())));
                continue;
            }
            if (!node.getNodeName().equals("count")) continue;
            String band = ((Element)node).getAttribute("bands");
            String sample = ((Element)node).getAttribute("sample");
            if (sample.equals("all")) {
                bandMap.put(band, null);
                continue;
            }
            HashMap<Integer, Integer> sampleMap = (HashMap<Integer, Integer>)bandMap.get(band);
            if (sampleMap == null && !bandMap.containsKey(band)) {
                sampleMap = new HashMap<Integer, Integer>();
                bandMap.put(band, sampleMap);
            }
            sampleMap.put(Integer.decode(sample), new Integer(0));
        }
        for (String band_str : bandMap.keySet()) {
            boolean addall;
            int[] band_indexes;
            if (buffimage.getType() == 12 || buffimage.getType() == 10) {
                band_indexes = new int[]{0};
            } else {
                band_indexes = new int[band_str.length()];
                for (int i = 0; i < band_str.length(); ++i) {
                    if (band_str.charAt(i) == 'A') {
                        band_indexes[i] = 3;
                    }
                    if (band_str.charAt(i) == 'B') {
                        band_indexes[i] = 2;
                    }
                    if (band_str.charAt(i) == 'G') {
                        band_indexes[i] = 1;
                    }
                    if (band_str.charAt(i) != 'R') continue;
                    band_indexes[i] = 0;
                }
            }
            WritableRaster raster = buffimage.getRaster();
            HashMap<Integer, Integer> sampleMap = (HashMap<Integer, Integer>)bandMap.get(band_str);
            boolean bl = addall = sampleMap == null;
            if (sampleMap == null) {
                sampleMap = new HashMap<Integer, Integer>();
                bandMap.put(band_str, sampleMap);
            }
            int minx = raster.getMinX();
            int maxx = minx + raster.getWidth();
            int miny = raster.getMinY();
            int maxy = miny + raster.getHeight();
            int[][] bands = new int[band_indexes.length][raster.getWidth()];
            int y = miny;
            for (int i = 0; i < band_indexes.length; ++i) {
                raster.getSamples(minx, y, maxx, 1, band_indexes[i], bands[i]);
            }
            for (int x = minx; x < maxx; ++x) {
                int sample = 0;
                for (int i = 0; i < band_indexes.length; ++i) {
                    sample |= bands[i][x] << (band_indexes.length - i - 1) * 8;
                }
                Integer sampleObj = new Integer(sample);
                boolean add = addall;
                if (!addall) {
                    add = sampleMap.containsKey(sampleObj);
                }
                if (!add) continue;
                Integer count = (Integer)sampleMap.get(sampleObj);
                if (count == null) {
                    count = new Integer(0);
                }
                count = new Integer(count + 1);
                sampleMap.put(sampleObj, count);
            }
            ++y;
        }
        LOGR.log(Level.FINE, "Final bandMap:\n{0}", bandMap);
        for (Node node = propNodes.item(0); node != null; node = node.getNextSibling()) {
            if (!node.getNodeName().equals("count")) continue;
            String band = ((Element)node).getAttribute("bands");
            String sample = ((Element)node).getAttribute("sample");
            HashMap sampleMap = (HashMap)bandMap.get(band);
            Document doc = node.getOwnerDocument();
            if (sample.equals("all")) {
                String prefix;
                int digits;
                Node parent = node.getParentNode();
                Node prevSibling = node.getPreviousSibling();
                Iterator sampleIt = sampleMap.keySet().iterator();
                Element countnode = null;
                switch (buffimage.getType()) {
                    case 12: {
                        digits = 1;
                        prefix = "";
                        break;
                    }
                    case 10: {
                        digits = 2;
                        prefix = "0x";
                        break;
                    }
                    default: {
                        prefix = "0x";
                        digits = band.length() * 2;
                    }
                }
                while (sampleIt.hasNext()) {
                    countnode = doc.createElement("count");
                    Integer sampleInt = (Integer)sampleIt.next();
                    Integer count = (Integer)sampleMap.get(sampleInt);
                    if (band.length() > 0) {
                        countnode.setAttribute("bands", band);
                    }
                    countnode.setAttribute("sample", prefix + ImageStats.HexString(sampleInt, digits));
                    Text textnode = doc.createTextNode(count.toString());
                    countnode.appendChild(textnode);
                    parent.insertBefore(countnode, node);
                    if (!sampleIt.hasNext() || prevSibling.getNodeType() != 3) continue;
                    parent.insertBefore(prevSibling.cloneNode(false), node);
                }
                parent.removeChild(node);
                node = countnode;
                continue;
            }
            Integer count = (Integer)sampleMap.get(Integer.decode(sample));
            if (count == null) {
                count = new Integer(0);
            }
            Text textnode = doc.createTextNode(count.toString());
            node.appendChild(textnode);
        }
    }

    private static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    String transform(Object imgContent, InputStream imgStats) {
        if (System.getProperty("java.awt.headless") == null) {
            System.setProperty("java.awt.headless", "true");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            Document doc;
            ImageProducer producer;
            try {
                producer = (ImageProducer)imgContent;
            }
            catch (Exception e) {
                this.addLogMessage("Error: Not a recognized image format. " + e.getMessage());
                return null;
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            try {
                doc = db.parse(imgStats);
            }
            catch (Exception e) {
                this.addLogMessage("Error: Could not parse image parameters.");
                this.addLogMessage(e.getClass().getName() + ": " + e.getMessage());
                return null;
            }
            Image image = Toolkit.getDefaultToolkit().createImage(producer);
            ImageTracker tracker = new ImageTracker(image);
            String type = tracker.getImageType();
            int height = image.getHeight(tracker);
            int width = image.getWidth(tracker);
            NodeList nodes = doc.getChildNodes();
            Node node = nodes.item(0);
            if (!node.getNodeName().equals("image_stats")) {
                this.addLogMessage("Error: Expecting root node to be named 'image_stats'.  Found '" + node.getNodeName() + "'.");
                return null;
            }
            nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                if (node.getNodeName().equals("type")) {
                    node.appendChild(doc.createTextNode(type));
                    continue;
                }
                if (node.getNodeName().equals("height")) {
                    node.appendChild(doc.createTextNode(Integer.toString(height)));
                    continue;
                }
                if (node.getNodeName().equals("width")) {
                    node.appendChild(doc.createTextNode(Integer.toString(width)));
                    continue;
                }
                if (!node.getNodeName().equals("model")) continue;
                String model = ((Element)node).getAttribute("value");
                int imagetype = model.equals("MONOCHROME") ? 12 : (model.equals("GRAY") ? 10 : (model.equals("RGB") ? 5 : (model.equals("ARGB") ? 6 : 0)));
                BufferedImage buffImage = new BufferedImage(width, height, imagetype);
                Graphics2D g2 = buffImage.createGraphics();
                g2.drawImage(image, 0, 0, tracker);
                ImageStats.processBufferedImage(buffImage, node.getChildNodes());
            }
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer t = tf.newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.transform(new DOMSource(doc), new StreamResult(bos));
        }
        catch (Exception e) {
            this.addLogMessage(e.getClass().toString());
        }
        return bos.toString();
    }

    private class ImageTracker
    implements ImageObserver {
        private boolean done;
        private int flags;
        private Image image;
        private String type;

        public ImageTracker(Image image) {
            this(image, true);
        }

        public ImageTracker(Image image, boolean wait) {
            this.image = image;
            if (wait) {
                ImageTracker tracker = new ImageTracker(image, false);
                tracker.waitForImage();
                this.type = tracker.getImageType();
                this.done = true;
            } else {
                this.type = null;
                this.done = false;
            }
        }

        public String getImageType() {
            if (this.type == null) {
                while (this.image.getWidth(this) == -1 && !this.done) {
                    ImageStats.sleep(50L);
                }
            }
            return this.type;
        }

        @Override
        public synchronized boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            if (this.type == null) {
                try {
                    StringWriter sw = new StringWriter();
                    new Throwable("").printStackTrace(new PrintWriter(sw));
                    String stackTrace = sw.toString();
                    int i = stackTrace.indexOf("ImageDecoder.produceImage");
                    int j = stackTrace.lastIndexOf(".", i - 1);
                    this.type = stackTrace.substring(j + 1, i).toLowerCase();
                }
                catch (Exception e) {
                    this.type = "Could not determine";
                }
            }
            this.done = (infoflags & 0xC0) != 0 ? true : (infoflags & 0x30) != 0;
            return !this.done;
        }

        public boolean isDone() {
            return this.done;
        }

        public void waitForImage() {
            do {
                ImageStats.sleep(50L);
            } while (this.image.getWidth(this) == -1 && !this.done);
            while (this.image.getHeight(this) == -1 && !this.done) {
                ImageStats.sleep(50L);
            }
            Toolkit tk = Toolkit.getDefaultToolkit();
            if (tk.prepareImage(this.image, -1, -1, this)) {
                this.done = true;
            }
            while (!this.done) {
                ImageStats.sleep(50L);
            }
        }
    }
}

