/*
 * Decompiled with CFR 0.152.
 */
package com.galdosinc.glib.gml.coord;

import com.galdosinc.glib.gml.coord.CoordinateException;
import com.galdosinc.glib.gml.coord.CoordinateTupleList;
import com.galdosinc.glib.gml.coord.CoordinatesFormat;
import com.galdosinc.glib.xml.dom.DomChildAccess;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class CoordinatesReader {
    private CoordinatesFormat coordinatesFormat_;
    private CoordinateTupleList tupleList_;
    private List liveTupleList_;

    public CoordinatesFormat getCoordinatesFormat() {
        return this.coordinatesFormat_;
    }

    public void useCoordinateTupleList(CoordinateTupleList tupleList) {
        this.tupleList_ = tupleList;
        this.liveTupleList_ = this.tupleList_.asLiveList();
    }

    public CoordinateTupleList getCoordinateTupleList() {
        return this.tupleList_;
    }

    public void read(String coordinatesText, CoordinatesFormat cf) throws CoordinateException {
        if (this.tupleList_ == null) {
            throw new CoordinateException("CoordinatesReader: The desired CoordinateTupleList must be set prior to reading coordinates.");
        }
        String tupleSeparator = this.coordinatesFormat_.getTupleSeparator() + '\n';
        StringTokenizer tupleTokenizer = new StringTokenizer(coordinatesText, tupleSeparator);
        if (!tupleTokenizer.hasMoreTokens()) {
            return;
        }
        String nextTuple = tupleTokenizer.nextToken();
        double[] tuple = this.scanCoordinateTuple(nextTuple, -1);
        int dimension = tuple.length;
        if (this.tupleList_.getCoordinateTupleCount() == 0) {
            this.tupleList_.setCoordinateTuples(new double[][]{tuple}, true);
        } else {
            this.liveTupleList_.add(tuple);
        }
        while (tupleTokenizer.hasMoreTokens()) {
            nextTuple = tupleTokenizer.nextToken();
            tuple = this.scanCoordinateTuple(nextTuple, dimension);
            this.liveTupleList_.add(tuple);
        }
    }

    public void read(Element elem) throws CoordinateException {
        Attr decimalAttr;
        Attr tsAttr;
        this.coordinatesFormat_ = null;
        StringBuffer textBuffer = DomChildAccess.getElementTextContent(elem);
        CoordinatesFormat cf = this.coordinatesFormat_ = new CoordinatesFormat();
        Attr csAttr = elem.getAttributeNodeNS(null, "cs");
        if (csAttr != null) {
            cf.setCoordinateSeparator(csAttr.getValue());
        }
        if ((tsAttr = elem.getAttributeNodeNS(null, "ts")) != null) {
            cf.setTupleSeparator(tsAttr.getValue());
        }
        if ((decimalAttr = elem.getAttributeNodeNS(null, "decimal")) != null) {
            cf.setDecimalPoint(decimalAttr.getValue());
            if (!cf.getDecimalPoint().equals(CoordinatesFormat.getDefaultDecimalPoint())) {
                char defaultDecimalChar = CoordinatesFormat.getDefaultDecimalPoint().charAt(0);
                char decimalChar = cf.getDecimalPoint().charAt(0);
                for (int ii = 0; ii < textBuffer.length(); ++ii) {
                    if (textBuffer.charAt(ii) != decimalChar) continue;
                    textBuffer.setCharAt(ii, defaultDecimalChar);
                }
            }
        }
        this.read(textBuffer.toString(), cf);
    }

    private double[] scanCoordinateTuple(String text, int expectedDimension) throws CoordinateException {
        StringTokenizer coordTokenizer = new StringTokenizer(text, this.coordinatesFormat_.getCoordinateSeparator());
        double[] coordValues = null;
        if (expectedDimension == -1) {
            LinkedList<Double> coords = new LinkedList<Double>();
            while (coordTokenizer.hasMoreTokens()) {
                String nextCoord = coordTokenizer.nextToken();
                Double value = Double.valueOf(nextCoord);
                coords.add(value);
            }
            coordValues = new double[coords.size()];
            Iterator coordIter = coords.iterator();
            int counter = 0;
            while (coordIter.hasNext()) {
                coordValues[counter] = (Double)coordIter.next();
                ++counter;
            }
        } else {
            int counter;
            coordValues = new double[expectedDimension];
            for (counter = 0; coordTokenizer.hasMoreTokens() && counter < expectedDimension; ++counter) {
                String nextCoord = coordTokenizer.nextToken();
                coordValues[counter] = Double.parseDouble(nextCoord);
            }
            if (coordTokenizer.hasMoreTokens()) {
                throw new CoordinateException("The coordinate tuple " + text + " has more coordinates than expected " + expectedDimension);
            }
            if (counter != expectedDimension) {
                throw new CoordinateException("The coordinate tuple " + text + " has less coordinates (" + counter + ") than expected " + expectedDimension);
            }
        }
        return coordValues;
    }
}

