/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.parsers;

import java.io.ByteArrayInputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URLConnection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.opengroup.ts.handlers.extensions.ogc.ResponseTransformer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class CustomTransformer {
    public static Document parse(URLConnection uc, Element instruction, PrintWriter logger) throws Throwable {
        Object content = uc.getContent();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        Element response = doc.createElement("response");
        CustomTransformer.addHeaders(response, uc);
        String custom_class = instruction.getAttribute("class");
        if (custom_class != null) {
            Element custom = doc.createElement("custom");
            String argstring = instruction.getTextContent();
            CustomTransformer.addCustom(custom, content, custom_class, argstring, logger);
            response.appendChild(custom);
        }
        doc.appendChild(response);
        return doc;
    }

    private static void addHeaders(Element parent, URLConnection uc) {
        Document doc = parent.getOwnerDocument();
        Element headers = doc.createElement("headers");
        parent.appendChild(headers);
        int i = 0;
        while (true) {
            Text textNode;
            String headerKey = uc.getHeaderFieldKey(i);
            String headerValue = uc.getHeaderField(i);
            if (headerKey == null && headerValue == null) break;
            Element header = doc.createElement("header");
            headers.appendChild(header);
            Element element = doc.createElement("name");
            if (headerKey != null) {
                header.appendChild(element);
                textNode = doc.createTextNode(headerKey);
                element.appendChild(textNode);
            }
            element = doc.createElement("value");
            header.appendChild(element);
            textNode = doc.createTextNode(headerValue);
            element.appendChild(textNode);
            ++i;
        }
    }

    private static void addCustom(Element parent, Object content, String custom_class, String argstring, PrintWriter logger) throws Throwable {
        Class<?> c = Class.forName(custom_class);
        Class[] types = new Class[]{Object.class, String.class};
        Object[] args = new Object[]{content, argstring};
        ResponseTransformer rt = null;
        try {
            rt = (ResponseTransformer)c.getConstructor(types).newInstance(args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        rt.setLogger(logger);
        String response = rt.getTransformedDocument();
        if (response == null) {
            return;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(response.getBytes());
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer t = tf.newTransformer();
        t.transform(new StreamSource(bais), new DOMResult(parent));
    }
}

