/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.tools;

import com.sun.xml.fastinfoset.CommonResourceBundle;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SAXEventSerializer
extends DefaultHandler
implements LexicalHandler {
    private final Writer _writer;
    private boolean _charactersAreCDATA;
    private StringBuffer _characters;
    private final Stack<AttributeValueHolder[]> _namespaceStack = new Stack();
    protected List<AttributeValueHolder> _namespaceAttributes;

    public SAXEventSerializer(OutputStream s2) throws IOException {
        this._writer = new OutputStreamWriter(s2);
        this._charactersAreCDATA = false;
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this._writer.write("<sax xmlns=\"http://www.sun.com/xml/sax-events\">\n");
            this._writer.write("<startDocument/>\n");
            this._writer.flush();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this._writer.write("<endDocument/>\n");
            this._writer.write("</sax>");
            this._writer.flush();
            this._writer.close();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this._namespaceAttributes == null) {
            this._namespaceAttributes = new ArrayList<AttributeValueHolder>();
        }
        Object qName = prefix.isEmpty() ? "xmlns" : "xmlns" + prefix;
        AttributeValueHolder attribute = new AttributeValueHolder((String)qName, prefix, uri, null, null);
        this._namespaceAttributes.add(attribute);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            AttributeValueHolder[] attrsHolder;
            this.outputCharacters();
            if (this._namespaceAttributes != null) {
                attrsHolder = new AttributeValueHolder[]{};
                attrsHolder = this._namespaceAttributes.toArray(attrsHolder);
                this.quicksort(attrsHolder, 0, attrsHolder.length - 1);
                for (AttributeValueHolder attrsHolder1 : attrsHolder) {
                    this._writer.write("<startPrefixMapping prefix=\"" + attrsHolder1.localName + "\" uri=\"" + attrsHolder1.uri + "\"/>\n");
                    this._writer.flush();
                }
                this._namespaceStack.push(attrsHolder);
                this._namespaceAttributes = null;
            } else {
                this._namespaceStack.push(null);
            }
            attrsHolder = new AttributeValueHolder[attributes.getLength()];
            for (int i = 0; i < attributes.getLength(); ++i) {
                attrsHolder[i] = new AttributeValueHolder(attributes.getQName(i), attributes.getLocalName(i), attributes.getURI(i), attributes.getType(i), attributes.getValue(i));
            }
            this.quicksort(attrsHolder, 0, attrsHolder.length - 1);
            int attributeCount = 0;
            for (AttributeValueHolder attrsHolder1 : attrsHolder) {
                if (attrsHolder1.uri.equals("http://www.w3.org/2000/xmlns/")) continue;
                ++attributeCount;
            }
            if (attributeCount == 0) {
                this._writer.write("<startElement uri=\"" + uri + "\" localName=\"" + localName + "\" qName=\"" + qName + "\"/>\n");
                return;
            }
            this._writer.write("<startElement uri=\"" + uri + "\" localName=\"" + localName + "\" qName=\"" + qName + "\">\n");
            for (AttributeValueHolder attrsHolder1 : attrsHolder) {
                if (attrsHolder1.uri.equals("http://www.w3.org/2000/xmlns/")) continue;
                this._writer.write("  <attribute qName=\"" + attrsHolder1.qName + "\" localName=\"" + attrsHolder1.localName + "\" uri=\"" + attrsHolder1.uri + "\" value=\"" + attrsHolder1.value + "\"/>\n");
            }
            this._writer.write("</startElement>\n");
            this._writer.flush();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.outputCharacters();
            this._writer.write("<endElement uri=\"" + uri + "\" localName=\"" + localName + "\" qName=\"" + qName + "\"/>\n");
            this._writer.flush();
            AttributeValueHolder[] attrsHolder = this._namespaceStack.pop();
            if (attrsHolder != null) {
                for (AttributeValueHolder attrsHolder1 : attrsHolder) {
                    this._writer.write("<endPrefixMapping prefix=\"" + attrsHolder1.localName + "\"/>\n");
                    this._writer.flush();
                }
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (length == 0) {
            return;
        }
        if (this._characters == null) {
            this._characters = new StringBuffer();
        }
        this._characters.append(ch, start, length);
    }

    private void outputCharacters() throws SAXException {
        if (this._characters == null) {
            return;
        }
        try {
            this._writer.write("<characters>" + (this._charactersAreCDATA ? "<![CDATA[" : "") + String.valueOf(this._characters) + (this._charactersAreCDATA ? "]]>" : "") + "</characters>\n");
            this._writer.flush();
            this._characters = null;
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        try {
            this.outputCharacters();
            this._writer.write("<processingInstruction target=\"" + target + "\" data=\"" + data + "\"/>\n");
            this._writer.flush();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
        this._charactersAreCDATA = true;
    }

    @Override
    public void endCDATA() throws SAXException {
        this._charactersAreCDATA = false;
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        try {
            this.outputCharacters();
            this._writer.write("<comment>" + new String(ch, start, length) + "</comment>\n");
            this._writer.flush();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    private void quicksort(AttributeValueHolder[] attrs, int p, int r) {
        while (p < r) {
            int q = this.partition(attrs, p, r);
            this.quicksort(attrs, p, q);
            p = q + 1;
        }
    }

    private int partition(AttributeValueHolder[] attrs, int p, int r) {
        AttributeValueHolder x = attrs[p + r >>> 1];
        int i = p - 1;
        int j = r + 1;
        while (true) {
            if (x.compareTo(attrs[--j]) < 0) {
                continue;
            }
            while (x.compareTo(attrs[++i]) > 0) {
            }
            if (i >= j) break;
            AttributeValueHolder t2 = attrs[i];
            attrs[i] = attrs[j];
            attrs[j] = t2;
        }
        return j;
    }

    public static class AttributeValueHolder
    implements Comparable<AttributeValueHolder> {
        public final String qName;
        public final String localName;
        public final String uri;
        public final String type;
        public final String value;

        public AttributeValueHolder(String qName, String localName, String uri, String type, String value) {
            this.qName = qName;
            this.localName = localName;
            this.uri = uri;
            this.type = type;
            this.value = value;
        }

        @Override
        public int compareTo(AttributeValueHolder o) {
            try {
                return this.qName.compareTo(o.qName);
            }
            catch (Exception e) {
                throw new RuntimeException(CommonResourceBundle.getInstance().getString("message.AttributeValueHolderExpected"));
            }
        }

        public boolean equals(Object o) {
            try {
                return o instanceof AttributeValueHolder && this.qName.equals(((AttributeValueHolder)o).qName);
            }
            catch (Exception e) {
                throw new RuntimeException(CommonResourceBundle.getInstance().getString("message.AttributeValueHolderExpected"));
            }
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + (this.qName != null ? this.qName.hashCode() : 0);
            return hash;
        }
    }
}

