/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding;

import jakarta.activation.ActivationDataFlavor;
import jakarta.activation.DataContentHandler;
import jakarta.activation.DataSource;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class ImageDataContentHandler
extends Component
implements DataContentHandler {
    private static final long serialVersionUID = 130664531531627353L;
    private static final Logger log = Logger.getLogger(ImageDataContentHandler.class.getName());
    private final ActivationDataFlavor[] flavor;

    public ImageDataContentHandler() {
        String[] mimeTypes = ImageIO.getReaderMIMETypes();
        this.flavor = new ActivationDataFlavor[mimeTypes.length];
        for (int i = 0; i < mimeTypes.length; ++i) {
            this.flavor[i] = new ActivationDataFlavor(Image.class, mimeTypes[i], "Image");
        }
    }

    @Override
    public ActivationDataFlavor[] getTransferDataFlavors() {
        return Arrays.copyOf(this.flavor, this.flavor.length);
    }

    @Override
    public Object getTransferData(ActivationDataFlavor df, DataSource ds) throws IOException {
        for (ActivationDataFlavor aFlavor : this.flavor) {
            if (!aFlavor.equals(df)) continue;
            return this.getContent(ds);
        }
        return null;
    }

    @Override
    public Object getContent(DataSource ds) throws IOException {
        return ImageIO.read(new BufferedInputStream(ds.getInputStream()));
    }

    @Override
    public void writeTo(Object obj, String type, OutputStream os) throws IOException {
        try {
            BufferedImage bufImage;
            if (obj instanceof BufferedImage) {
                bufImage = (BufferedImage)obj;
            } else if (obj instanceof Image) {
                bufImage = this.render((Image)obj);
            } else {
                throw new IOException("ImageDataContentHandler requires Image object, was given object of type " + obj.getClass().toString());
            }
            ImageWriter writer = null;
            Iterator<ImageWriter> i = ImageIO.getImageWritersByMIMEType(type);
            if (i.hasNext()) {
                writer = i.next();
            }
            if (writer == null) {
                throw new IOException("Unsupported mime type:" + type);
            }
            ImageOutputStream stream = ImageIO.createImageOutputStream(os);
            writer.setOutput(stream);
            writer.write(bufImage);
            writer.dispose();
            stream.close();
        }
        catch (Exception e) {
            throw new IOException("Unable to encode the image to a stream " + e.getMessage());
        }
    }

    private BufferedImage render(Image img) throws InterruptedException {
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(img, 0);
        tracker.waitForAll();
        BufferedImage bufImage = new BufferedImage(img.getWidth(null), img.getHeight(null), 1);
        Graphics2D g2 = bufImage.createGraphics();
        g2.drawImage(img, 0, 0, null);
        g2.dispose();
        return bufImage;
    }
}

