/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.message.jaxws;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.commons.xmlutil.Converter;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.localization.LocalizationMessages;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;

public final class SerializableMessage {
    private static final Logger LOGGER = Logger.getLogger(SerializableMessage.class);
    @Nullable
    private Packet packet;
    @NotNull
    private final Message message;
    @Nullable
    private final String wsaAction;

    public SerializableMessage(Packet packet, String wsaAction) {
        this.packet = packet;
        this.message = packet.getMessage();
        this.wsaAction = wsaAction;
    }

    public SerializableMessage(Message message, String wsaAction) {
        assert (message != null);
        this.packet = null;
        this.message = message;
        this.wsaAction = wsaAction;
    }

    public Message getMessage() {
        return this.message;
    }

    public Packet getPacket() {
        return this.packet;
    }

    public void setPacket(Packet newPacket) {
        newPacket.setMessage(this.message);
        this.packet = newPacket;
    }

    public String getWsaAction() {
        return this.wsaAction;
    }

    public byte[] toBytes() {
        try {
            return Converter.toBytes(this.message.copy(), "UTF-8");
        }
        catch (XMLStreamException ex) {
            throw LOGGER.logSevereException(new RxRuntimeException(LocalizationMessages.WSRX_1001_UNABLE_TO_SERIALIZE_MSG_TO_XML_STREAM(), ex));
        }
    }

    public static SerializableMessage newInstance(@NotNull InputStream dataStream, String wsaAction) {
        Message m4;
        try {
            m4 = Converter.toMessage(dataStream, "UTF-8");
        }
        catch (XMLStreamException ex) {
            throw LOGGER.logSevereException(new RxRuntimeException(LocalizationMessages.WSRX_1002_UNABLE_TO_DESERIALIZE_MSG_FROM_XML_STREAM(), ex));
        }
        return new SerializableMessage(m4, wsaAction);
    }
}

