/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policyconv;

import com.sun.xml.ws.security.policy.MessageLayout;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.policy.MLSPolicy;
import com.sun.xml.wss.impl.policy.PolicyGenerationException;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionPolicy;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.impl.policy.mls.Target;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;

public class XWSSPolicyContainer {
    private boolean isServer;
    private boolean isIncoming;
    private Section section;
    private List<SecurityPolicy> policyList;
    private List<SecurityPolicy> effectivePolicyList;
    private MessageLayout mode;
    private int foundTimestamp = -1;
    private boolean modified = false;

    private boolean encPoliciesContain(QName qName, List<SecurityPolicy> encPolicies) {
        if (qName.equals(Target.BODY_QNAME)) {
            return false;
        }
        for (SecurityPolicy sp : encPolicies) {
            if (!PolicyTypeUtil.encryptionPolicy(sp)) continue;
            EncryptionPolicy.FeatureBinding fb = (EncryptionPolicy.FeatureBinding)((EncryptionPolicy)sp).getFeatureBinding();
            ArrayList targets = fb.getTargetBindings();
            for (int i = 0; i < targets.size(); ++i) {
                Target t2 = (Target)targets.get(i);
                if (t2.getType() != "qname" || !qName.equals(t2.getQName())) continue;
                return true;
            }
        }
        return false;
    }

    private void fixEncryptedTargetsInSignature(MessagePolicy msgPolicy, boolean isWSS11) {
        boolean encryptBeforeSign = false;
        boolean seenEncryptPolicy = false;
        boolean seenSignPolicy = false;
        ArrayList<SecurityPolicy> encPolicies = new ArrayList<SecurityPolicy>();
        for (Object policy : msgPolicy.getPrimaryPolicies()) {
            if (!(policy instanceof SecurityPolicy)) continue;
            SecurityPolicy secPolicy = (SecurityPolicy)policy;
            if (PolicyTypeUtil.signaturePolicy(secPolicy)) {
                seenSignPolicy = true;
                if (seenEncryptPolicy || !this.isIncoming) continue;
                encryptBeforeSign = true;
                continue;
            }
            if (!PolicyTypeUtil.encryptionPolicy(secPolicy)) continue;
            seenEncryptPolicy = true;
            if (!seenSignPolicy && !this.isIncoming) {
                encryptBeforeSign = true;
            }
            encPolicies.add(secPolicy);
        }
        if (encryptBeforeSign) {
            for (Object policy : msgPolicy.getPrimaryPolicies()) {
                SecurityPolicy secPolicy;
                boolean containsEncryptedHeader = false;
                if (!(policy instanceof SecurityPolicy) || !PolicyTypeUtil.signaturePolicy(secPolicy = (SecurityPolicy)policy)) continue;
                SignaturePolicy.FeatureBinding sfb = (SignaturePolicy.FeatureBinding)((SignaturePolicy)secPolicy).getFeatureBinding();
                ArrayList targets = sfb.getTargetBindings();
                for (int i = 0; i < targets.size(); ++i) {
                    Target t2 = (Target)targets.get(i);
                    if (t2.getType() != "qname" || !this.encPoliciesContain(t2.getQName(), encPolicies)) continue;
                    if (isWSS11) {
                        if (!containsEncryptedHeader) {
                            QName encHeaderQName = new QName("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "EncryptedHeader");
                            t2.setQName(encHeaderQName);
                            containsEncryptedHeader = true;
                            continue;
                        }
                        targets.remove(i);
                        continue;
                    }
                    if (!containsEncryptedHeader) {
                        QName encDataQName = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "EncryptedData");
                        t2.setQName(encDataQName);
                        containsEncryptedHeader = true;
                        continue;
                    }
                    targets.remove(i);
                }
            }
        }
    }

    public XWSSPolicyContainer(MessageLayout mode, boolean isServer, boolean isIncoming) {
        this.mode = mode;
        this.isServer = isServer;
        this.isIncoming = isIncoming;
        this.setMessageMode(isServer, isIncoming);
        this.effectivePolicyList = new ArrayList<SecurityPolicy>();
    }

    public XWSSPolicyContainer(boolean isServer, boolean isIncoming) {
        this.setMessageMode(isServer, isIncoming);
        this.isServer = isServer;
        this.isIncoming = isIncoming;
        this.effectivePolicyList = new ArrayList<SecurityPolicy>();
    }

    public void setMessageMode(boolean isServer, boolean isIncoming) {
        if (isServer && isIncoming) {
            this.section = Section.ServerIncomingPolicy;
        } else if (isServer && !isIncoming) {
            this.section = Section.ServerOutgoingPolicy;
        } else if (!isServer && isIncoming) {
            this.section = Section.ClientIncomingPolicy;
        } else if (!isServer && !isIncoming) {
            this.section = Section.ClientOutgoingPolicy;
        }
    }

    public void setPolicyContainerMode(MessageLayout mode) {
        this.mode = mode;
    }

    public void insert(SecurityPolicy secPolicy) {
        if (secPolicy == null) {
            return;
        }
        if (this.policyList == null) {
            this.policyList = new ArrayList<SecurityPolicy>();
        }
        if (this.isSupportingToken(secPolicy)) {
            switch (this.section.ordinal()) {
                case 0: 
                case 3: {
                    return;
                }
            }
        }
        this.modified = true;
        this.policyList.add(secPolicy);
    }

    public MessagePolicy getMessagePolicy(boolean isWSS11) throws PolicyGenerationException {
        if (this.modified) {
            this.convert();
            this.modified = false;
        }
        MessagePolicy msgPolicy = new MessagePolicy();
        msgPolicy.appendAll(this.effectivePolicyList);
        this.removeEmptyPrimaryPolicies(msgPolicy);
        this.fixEncryptedTargetsInSignature(msgPolicy, isWSS11);
        return msgPolicy;
    }

    private void removeEmptyPrimaryPolicies(MessagePolicy msgPolicy) {
        for (Object policy : msgPolicy.getPrimaryPolicies()) {
            if (!(policy instanceof SecurityPolicy)) continue;
            SecurityPolicy secPolicy = (SecurityPolicy)policy;
            if (PolicyTypeUtil.signaturePolicy(secPolicy)) {
                if (((SignaturePolicy.FeatureBinding)((SignaturePolicy)secPolicy).getFeatureBinding()).getTargetBindings().size() != 0) continue;
                msgPolicy.remove(secPolicy);
                continue;
            }
            if (!PolicyTypeUtil.encryptionPolicy(secPolicy) || ((EncryptionPolicy.FeatureBinding)((EncryptionPolicy)secPolicy).getFeatureBinding()).getTargetBindings().size() != 0) continue;
            msgPolicy.remove(secPolicy);
        }
    }

    private void appendAfterToken(SecurityPolicy xwssPolicy) {
        int pos = -1;
        for (SecurityPolicy secPolicy : this.effectivePolicyList) {
            if (this.isSupportingToken(secPolicy) || this.isTimestamp(secPolicy)) continue;
            pos = this.effectivePolicyList.indexOf(secPolicy);
            break;
        }
        if (pos != -1) {
            this.effectivePolicyList.add(pos, xwssPolicy);
        } else {
            this.effectivePolicyList.add(xwssPolicy);
        }
    }

    private void prependBeforeToken(SecurityPolicy xwssPolicy) {
        int pos = -1;
        for (SecurityPolicy secPolicy : this.effectivePolicyList) {
            if (!this.isSupportingToken(secPolicy)) continue;
            pos = this.effectivePolicyList.indexOf(secPolicy);
        }
        if (pos != -1) {
            this.effectivePolicyList.add(pos, xwssPolicy);
        } else {
            this.effectivePolicyList.add(xwssPolicy);
        }
    }

    private void append(SecurityPolicy xwssPolicy) {
        this.effectivePolicyList.add(xwssPolicy);
    }

    private void prepend(SecurityPolicy xwssPolicy) {
        this.effectivePolicyList.add(0, xwssPolicy);
    }

    private boolean isSupportingToken(SecurityPolicy xwssPolicy) {
        if (xwssPolicy == null) {
            return false;
        }
        if (PolicyTypeUtil.authenticationTokenPolicy(xwssPolicy)) {
            MLSPolicy binding = ((AuthenticationTokenPolicy)xwssPolicy).getFeatureBinding();
            return PolicyTypeUtil.usernameTokenPolicy(binding) || PolicyTypeUtil.samlTokenPolicy(binding) || PolicyTypeUtil.x509CertificateBinding(binding) || PolicyTypeUtil.issuedTokenKeyBinding(binding);
        }
        return false;
    }

    private boolean isTimestamp(SecurityPolicy xwssPolicy) {
        return xwssPolicy != null && PolicyTypeUtil.timestampPolicy(xwssPolicy);
    }

    private void convertLax() {
        for (SecurityPolicy xwssPolicy : this.policyList) {
            if (this.isTimestamp(xwssPolicy)) {
                this.foundTimestamp = this.policyList.indexOf(xwssPolicy);
                this.prepend(xwssPolicy);
                continue;
            }
            if (!this.isSupportingToken(xwssPolicy)) {
                switch (this.section.ordinal()) {
                    case 0: {
                        this.prepend(xwssPolicy);
                        break;
                    }
                    case 1: {
                        this.append(xwssPolicy);
                        break;
                    }
                    case 2: {
                        this.appendAfterToken(xwssPolicy);
                        break;
                    }
                    case 3: {
                        this.append(xwssPolicy);
                    }
                }
                continue;
            }
            if (!this.isSupportingToken(xwssPolicy) && !this.isTimestamp(xwssPolicy)) continue;
            this.prepend(xwssPolicy);
        }
    }

    private void convertStrict() {
        for (SecurityPolicy xwssPolicy : this.policyList) {
            if (this.isSupportingToken(xwssPolicy)) {
                this.prepend(xwssPolicy);
                continue;
            }
            if (this.isTimestamp(xwssPolicy)) {
                this.prepend(xwssPolicy);
                continue;
            }
            switch (this.section.ordinal()) {
                case 0: {
                    this.appendAfterToken(xwssPolicy);
                    break;
                }
                case 1: {
                    this.append(xwssPolicy);
                    break;
                }
                case 2: {
                    this.appendAfterToken(xwssPolicy);
                    break;
                }
                case 3: {
                    this.append(xwssPolicy);
                }
            }
        }
    }

    private void convertLaxTsFirst() {
        this.convertLax();
        if (this.foundTimestamp != -1) {
            switch (this.section.ordinal()) {
                case 1: {
                    this.effectivePolicyList.add(0, this.effectivePolicyList.remove(this.foundTimestamp));
                    break;
                }
                case 3: {
                    this.effectivePolicyList.add(0, this.effectivePolicyList.remove(this.foundTimestamp));
                }
            }
        }
    }

    private void convertLaxTsLast() {
        this.convertLax();
        if (this.foundTimestamp != -1) {
            switch (this.section.ordinal()) {
                case 1: {
                    this.effectivePolicyList.add(this.effectivePolicyList.size() - 1, this.effectivePolicyList.remove(this.foundTimestamp));
                    break;
                }
                case 3: {
                    this.effectivePolicyList.add(this.effectivePolicyList.size() - 1, this.effectivePolicyList.remove(this.foundTimestamp));
                }
            }
        }
    }

    public void convert() {
        if (MessageLayout.Lax == this.mode) {
            this.convertLax();
        } else if (MessageLayout.Strict == this.mode) {
            this.convertStrict();
        } else if (MessageLayout.LaxTsFirst == this.mode) {
            this.convertLaxTsFirst();
        } else if (MessageLayout.LaxTsLast == this.mode) {
            this.convertLaxTsLast();
        }
    }

    private static enum Section {
        ClientIncomingPolicy,
        ClientOutgoingPolicy,
        ServerIncomingPolicy,
        ServerOutgoingPolicy;

    }
}

