/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server;

import com.sun.xml.ws.api.server.AbstractInstanceResolver;
import com.sun.xml.ws.api.server.ResourceInjector;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WSWebServiceContext;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.lang.reflect.Method;

public abstract class AbstractMultiInstanceResolver<T>
extends AbstractInstanceResolver<T> {
    protected final Class<T> clazz;
    private WSWebServiceContext webServiceContext;
    protected WSEndpoint owner;
    private final Method postConstructMethod;
    private final Method preDestroyMethod;
    private ResourceInjector resourceInjector;

    public AbstractMultiInstanceResolver(Class<T> clazz) {
        this.clazz = clazz;
        this.postConstructMethod = this.findAnnotatedMethod(clazz, PostConstruct.class);
        this.preDestroyMethod = this.findAnnotatedMethod(clazz, PreDestroy.class);
    }

    protected final void prepare(T t2) {
        assert (this.webServiceContext != null);
        this.resourceInjector.inject(this.webServiceContext, t2);
        AbstractMultiInstanceResolver.invokeMethod(this.postConstructMethod, t2, new Object[0]);
    }

    protected final T create() {
        T t2 = AbstractMultiInstanceResolver.createNewInstance(this.clazz);
        this.prepare(t2);
        return t2;
    }

    @Override
    public void start(WSWebServiceContext wsc, WSEndpoint endpoint) {
        this.resourceInjector = AbstractMultiInstanceResolver.getResourceInjector(endpoint);
        this.webServiceContext = wsc;
        this.owner = endpoint;
    }

    protected final void dispose(T instance) {
        AbstractMultiInstanceResolver.invokeMethod(this.preDestroyMethod, instance, new Object[0]);
    }
}

