/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at.common;

import com.sun.xml.ws.tx.at.common.TransactionImportManager;
import com.sun.xml.ws.tx.at.common.TxLogger;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionSynchronizationRegistry;
import jakarta.transaction.UserTransaction;
import java.lang.reflect.Method;
import java.util.logging.Level;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class TransactionManagerImpl
implements TransactionManager,
TransactionSynchronizationRegistry {
    private static final TxLogger logger = TxLogger.getATLogger(TransactionManagerImpl.class);
    private static final String AS_TXN_MGR_JNDI_NAME = "java:appserver/TransactionManager";
    private static final String TXN_MGR_JNDI_NAME = System.getProperty("com.sun.xml.ws.tx.txnMgrJndiName", "java:appserver/TransactionManager");
    private static final String TXN_SYNC_REG_JNDI_NAME = "java:comp/TransactionSynchronizationRegistry";
    private static final String USER_TRANSACTION_JNDI_NAME = "java:comp/UserTransaction";
    private static final TransactionManagerImpl singleton = new TransactionManagerImpl();
    private final TransactionManager javaeeTM = (TransactionManager)TransactionManagerImpl.jndiLookup(TXN_MGR_JNDI_NAME);
    private final TransactionSynchronizationRegistry javaeeSynchReg = (TransactionSynchronizationRegistry)TransactionManagerImpl.jndiLookup("java:comp/TransactionSynchronizationRegistry");
    private static boolean initialized = false;
    private static Method servletPreInvokeTxMethod = null;
    private static Method servletPostInvokeTxMethod = null;

    public static TransactionManagerImpl getInstance() {
        return singleton;
    }

    private static Object jndiLookup(String jndiName) {
        Object result = null;
        try {
            InitialContext ctx = new InitialContext();
            result = ctx.lookup(jndiName);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return result;
    }

    private TransactionManagerImpl() {
    }

    public TransactionManager getTransactionManager() {
        return this.javaeeTM;
    }

    public UserTransaction getUserTransaction() {
        return (UserTransaction)TransactionManagerImpl.jndiLookup(USER_TRANSACTION_JNDI_NAME);
    }

    public boolean isTransactionManagerAvailable() {
        return this.javaeeTM != null;
    }

    public void begin() throws NotSupportedException, SystemException {
        this.javaeeTM.begin();
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.javaeeTM.commit();
    }

    public int getStatus() throws SystemException {
        return this.javaeeTM.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        return this.javaeeTM.getTransaction();
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        this.javaeeTM.resume(transaction);
        this.servletPreInvokeTx();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.javaeeTM.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException {
        this.javaeeSynchReg.setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.javaeeTM.setTransactionTimeout(seconds);
    }

    public Transaction suspend() throws SystemException {
        this.servletPostInvokeTx(true);
        return this.javaeeTM.suspend();
    }

    public Object getTransactionKey() {
        return this.javaeeSynchReg.getTransactionKey();
    }

    public void putResource(Object object, Object object0) {
        this.javaeeSynchReg.putResource(object, object0);
    }

    public Object getResource(Object object) {
        return this.javaeeSynchReg.getResource(object);
    }

    public void registerInterposedSynchronization(Synchronization synchronization) {
        this.javaeeSynchReg.registerInterposedSynchronization(synchronization);
    }

    public void registerSynchronization(Synchronization sync) {
        if (sync == null) {
            return;
        }
        Transaction txn = null;
        try {
            txn = this.javaeeTM.getTransaction();
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        if (txn != null) {
            try {
                txn.registerSynchronization(sync);
            }
            catch (RollbackException | SystemException | IllegalStateException throwable) {
                // empty catch block
            }
        }
    }

    public int getTransactionStatus() {
        return this.javaeeSynchReg.getTransactionStatus();
    }

    public boolean getRollbackOnly() {
        return this.javaeeSynchReg.getRollbackOnly();
    }

    private static Method getMethod(Class<?> theClass, String methodName, Class<?> param) {
        Method method = null;
        try {
            method = param == null ? theClass.getMethod(methodName, new Class[0]) : theClass.getMethod(methodName, param);
            logger.finest("getMethod", "found Sun App Server 9.1 container specific method via reflection " + theClass.getName() + "." + methodName);
        }
        catch (Exception e) {
            logger.finest("getMethod", "reflection lookup of  " + theClass.getName() + "." + methodName + "(" + (param == null ? "" : param.getName()) + ") failed with handled exception ", e);
        }
        return method;
    }

    private void initServletMethods() {
        if (!initialized) {
            initialized = true;
            servletPreInvokeTxMethod = TransactionManagerImpl.getMethod(this.javaeeTM.getClass(), "servletPreInvokeTx", null);
            servletPostInvokeTxMethod = TransactionManagerImpl.getMethod(this.javaeeTM.getClass(), "servletPostInvokeTx", Boolean.TYPE);
        }
    }

    public void servletPreInvokeTx() {
        this.initServletMethods();
        if (servletPreInvokeTxMethod != null) {
            try {
                servletPreInvokeTxMethod.invoke((Object)this.javaeeTM, new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void servletPostInvokeTx(Boolean suspend) {
        this.initServletMethods();
        if (servletPostInvokeTxMethod != null) {
            try {
                servletPostInvokeTxMethod.invoke((Object)this.javaeeTM, suspend);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public int getRemainingTimeout() {
        String METHOD = "getRemainingTimeout";
        try {
            return TransactionImportManager.getInstance().getTransactionRemainingTimeout();
        }
        catch (Throwable t2) {
            if (logger.isLogging(Level.FINEST)) {
                logger.finest("getRemainingTimeout", "getTransactionRemainingTimeout() failed, default to no timeout", t2);
            }
            return 0;
        }
    }
}

