/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at.internal;

import java.util.Locale;
import javax.transaction.xa.XAException;

class JTAHelper {
    JTAHelper() {
    }

    static void throwXAException(int errCode, String errMsg) throws XAException {
        XAException ex = new XAException(JTAHelper.xaErrorCodeToString(errCode) + ".  " + errMsg);
        ex.errorCode = errCode;
        throw ex;
    }

    static void throwXAException(int errCode, String errMsg, Throwable t2) throws XAException {
        XAException ex = new XAException(JTAHelper.xaErrorCodeToString(errCode) + ".  " + errMsg);
        ex.errorCode = errCode;
        ex.initCause(t2);
        throw ex;
    }

    static String xaErrorCodeToString(int err) {
        return JTAHelper.xaErrorCodeToString(err, true);
    }

    static String xaErrorCodeToString(int err, boolean detail) {
        StringBuilder msg = new StringBuilder(10);
        switch (err) {
            case 0: {
                return "XA_OK";
            }
            case 3: {
                return "XA_RDONLY";
            }
            case 7: {
                msg.append("XA_HEURCOM");
                if (detail) {
                    msg.append(" : The transaction branch has been heuristically committed");
                }
                return msg.toString();
            }
            case 8: {
                msg.append("XA_HEURHAZ");
                if (detail) {
                    msg.append(" : The transaction branch may have been heuristically completed");
                }
                return msg.toString();
            }
            case 5: {
                msg.append("XA_HEURMIX");
                if (detail) {
                    msg.append(" : The transaction branch has been heuristically committed and rolled back");
                }
                return msg.toString();
            }
            case 6: {
                msg.append("XA_HEURRB");
                if (detail) {
                    msg.append(" : The transaction branch has been heuristically rolled back");
                }
                return msg.toString();
            }
            case 101: {
                msg.append("XA_RBCOMMFAIL");
                if (detail) {
                    msg.append(" : Rollback was caused by communication failure");
                }
                return msg.toString();
            }
            case 102: {
                msg.append("XA_RBDEADLOCK");
                if (detail) {
                    msg.append(" : A deadlock was detected");
                }
                return msg.toString();
            }
            case 103: {
                msg.append("XA_RBINTEGRITY");
                if (detail) {
                    msg.append(" : A condition that violates the integrity of the resource was detected");
                }
                return msg.toString();
            }
            case 104: {
                msg.append("XA_RBOTHER");
                if (detail) {
                    msg.append(" : The resource manager rolled back the transaction branch for a reason not on this list");
                }
                return msg.toString();
            }
            case 105: {
                msg.append("XA_RBPROTO");
                if (detail) {
                    msg.append(" : A protocol error occured in the resource manager");
                }
                return msg.toString();
            }
            case 100: {
                msg.append("XA_RBROLLBACK");
                if (detail) {
                    msg.append(" : Rollback was caused by unspecified reason");
                }
                return msg.toString();
            }
            case 106: {
                msg.append("XA_RBTIMEOUT");
                if (detail) {
                    msg.append(" : A transaction branch took too long");
                }
                return msg.toString();
            }
            case 107: {
                msg.append("XA_RBTRANSIENT");
                if (detail) {
                    msg.append(" : May retry the transaction branch");
                }
                return msg.toString();
            }
            case -2: {
                msg.append("XAER_ASYNC");
                if (detail) {
                    msg.append(" : Asynchronous operation already outstanding");
                }
                return msg.toString();
            }
            case -8: {
                msg.append("XAER_DUPID");
                if (detail) {
                    msg.append(" : The XID already exists");
                }
                return msg.toString();
            }
            case -5: {
                msg.append("XAER_INVAL");
                if (detail) {
                    msg.append(" : Invalid arguments were given");
                }
                return msg.toString();
            }
            case -4: {
                msg.append("XAER_NOTA");
                if (detail) {
                    msg.append(" : The XID is not valid");
                }
                return msg.toString();
            }
            case -9: {
                msg.append("XAER_OUTSIDE");
                if (detail) {
                    msg.append(" : The resource manager is doing work outside global transaction");
                }
                return msg.toString();
            }
            case -6: {
                msg.append("XAER_PROTO");
                if (detail) {
                    msg.append(" : Routine was invoked in an inproper context");
                }
                return msg.toString();
            }
            case -3: {
                msg.append("XAER_RMERR");
                if (detail) {
                    msg.append(" : A resource manager error has occured in the transaction branch");
                }
                return msg.toString();
            }
            case -7: {
                msg.append("XAER_RMFAIL");
                if (detail) {
                    msg.append(" : Resource manager is unavailable");
                }
                return msg.toString();
            }
        }
        return Integer.toHexString(err).toUpperCase(Locale.ENGLISH);
    }
}

