/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.coord.common;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.MessageHeaders;
import com.sun.xml.ws.api.tx.at.Transactional;
import com.sun.xml.ws.tx.coord.common.types.CoordinationContextIF;
import com.sun.xml.ws.tx.coord.v11.CoordinationContextBuilderImpl;
import org.glassfish.jaxb.runtime.api.JAXBRIContext;

public abstract class CoordinationContextBuilder {
    protected String coordinationType;
    protected String identifier;
    protected long expires;
    protected String address;
    protected String txId;
    protected boolean mustUnderstand;
    protected SOAPVersion soapVersion;
    protected Header coordinationHeader;
    Transactional.Version version;

    protected CoordinationContextBuilder() {
    }

    public static CoordinationContextBuilder newInstance(Transactional.Version version) {
        if (Transactional.Version.WSAT10 == version) {
            return new com.sun.xml.ws.tx.coord.v10.CoordinationContextBuilderImpl();
        }
        if (Transactional.Version.WSAT11 == version || Transactional.Version.WSAT12 == version) {
            return new CoordinationContextBuilderImpl();
        }
        throw new IllegalArgumentException(String.valueOf((Object)version) + "is not a supported ws-at version");
    }

    public static CoordinationContextBuilder headers(MessageHeaders h2, Transactional.Version version) {
        CoordinationContextBuilder builder = null;
        HeaderList headers = (HeaderList)h2;
        for (int i = 0; i < headers.size(); ++i) {
            Header header = headers.get(i);
            if (!header.getLocalPart().equals("CoordinationContext")) continue;
            if ("http://schemas.xmlsoap.org/ws/2004/10/wscoor".equals(header.getNamespaceURI())) {
                if (version == Transactional.Version.WSAT10 || version == Transactional.Version.DEFAULT) {
                    builder = new com.sun.xml.ws.tx.coord.v10.CoordinationContextBuilderImpl();
                    builder.version = Transactional.Version.WSAT10;
                }
            } else if ("http://docs.oasis-open.org/ws-tx/wscoor/2006/06".equals(header.getNamespaceURI()) && version != Transactional.Version.WSAT10) {
                builder = new CoordinationContextBuilderImpl();
                builder.version = Transactional.Version.WSAT11;
            }
            if (builder == null) continue;
            headers.understood(i);
            return builder.header(header);
        }
        return null;
    }

    public Transactional.Version getVersion() {
        return this.version;
    }

    public CoordinationContextBuilder address(String address) {
        this.address = address;
        return this;
    }

    public CoordinationContextBuilder txId(String txId) {
        this.txId = txId;
        return this;
    }

    public CoordinationContextBuilder identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public CoordinationContextBuilder expires(long expires) {
        this.expires = expires;
        return this;
    }

    public CoordinationContextBuilder mustUnderstand(boolean mustUnderstand) {
        this.mustUnderstand = mustUnderstand;
        return this;
    }

    public CoordinationContextBuilder soapVersion(SOAPVersion soapVersion) {
        this.soapVersion = soapVersion;
        return this;
    }

    public CoordinationContextBuilder coordinationType(String coordinationType) {
        this.coordinationType = coordinationType;
        return this;
    }

    CoordinationContextBuilder header(Header coordinationHeader) {
        this.coordinationHeader = coordinationHeader;
        return this;
    }

    public CoordinationContextIF buildFromHeader() {
        return this._fromHeader(this.coordinationHeader);
    }

    protected abstract CoordinationContextIF _fromHeader(Header var1);

    public abstract CoordinationContextIF build();

    public abstract JAXBRIContext getJAXBRIContext();
}

