/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.core;

import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.elements.BinarySecret;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.EncryptedKeyToken;
import com.sun.xml.wss.core.SecurityHeaderBlock;
import com.sun.xml.wss.core.SecurityTokenReference;
import com.sun.xml.wss.impl.misc.SecurityHeaderBlockImpl;
import jakarta.xml.soap.SOAPElement;
import java.security.PublicKey;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.KeyName;
import org.apache.xml.security.keys.content.KeyValue;
import org.apache.xml.security.keys.content.MgmtData;
import org.apache.xml.security.keys.content.PGPData;
import org.apache.xml.security.keys.content.RetrievalMethod;
import org.apache.xml.security.keys.content.SPKIData;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.keyvalues.DSAKeyValue;
import org.apache.xml.security.keys.content.keyvalues.RSAKeyValue;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.ElementProxy;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KeyInfoHeaderBlock
extends SecurityHeaderBlockImpl {
    public static final String SignatureSpecNS = "http://www.w3.org/2000/09/xmldsig#";
    public static final String SignatureSpecNSprefix = "ds";
    public static final String TAG_KEYINFO = "KeyInfo";
    KeyInfo delegateKeyInfo = null;
    boolean dirty = false;
    private static Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");
    String baseURI = null;
    private Document document;

    public KeyInfoHeaderBlock(Document ownerDoc) throws XWSSecurityException {
        try {
            this.document = ownerDoc;
            this.delegateKeyInfo = new KeyInfo(ownerDoc);
            this.dirty = true;
            this.setSOAPElement(this.getAsSoapElement());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0318.exception.while.creating.keyinfoblock", e);
            throw new XWSSecurityException(e);
        }
    }

    public KeyInfoHeaderBlock(KeyInfo keyinfo) throws XWSSecurityException {
        this.document = keyinfo.getDocument();
        this.delegateKeyInfo = keyinfo;
        this.dirty = true;
        this.setSOAPElement(this.getAsSoapElement());
    }

    public void addKeyName(String keynameString) {
        this.delegateKeyInfo.addKeyName(keynameString);
        this.dirty = true;
    }

    public void addBinarySecret(SOAPElement binarySecret) {
        this.delegateKeyInfo.addUnknownElement(binarySecret);
        this.dirty = true;
    }

    public void addKeyName(SOAPElement keyname) throws XWSSecurityException {
        try {
            KeyName keynm = new KeyName(keyname, null);
            this.delegateKeyInfo.add(keynm);
            this.dirty = true;
        }
        catch (XMLSecurityException e) {
            log.log(Level.SEVERE, "WSS0319.exception.adding.keyname", e);
            throw new XWSSecurityException(e);
        }
    }

    public void addKeyValue(PublicKey pk) {
        this.delegateKeyInfo.addKeyValue(pk);
        this.dirty = true;
    }

    public void addUnknownKeyValue(SOAPElement unknownKeyValueElement) {
        this.delegateKeyInfo.addKeyValue(unknownKeyValueElement);
        this.dirty = true;
    }

    public void addDSAKeyValue(SOAPElement dsakeyvalue) throws XWSSecurityException {
        try {
            DSAKeyValue dsaKval = new DSAKeyValue(dsakeyvalue, null);
            this.delegateKeyInfo.add(dsaKval);
            this.dirty = true;
        }
        catch (XMLSecurityException e) {
            log.log(Level.SEVERE, "WSS0355.error.creating.keyvalue", new Object[]{"DSA", e.getMessage()});
            throw new XWSSecurityException(e);
        }
    }

    public void addRSAKeyValue(SOAPElement rsakeyvalue) throws XWSSecurityException {
        try {
            RSAKeyValue rsaKval = new RSAKeyValue(rsakeyvalue, null);
            this.delegateKeyInfo.add(rsaKval);
            this.dirty = true;
        }
        catch (XMLSecurityException e) {
            log.log(Level.SEVERE, "WSS0355.error.creating.keyvalue", new Object[]{"RSA", e.getMessage()});
            throw new XWSSecurityException(e);
        }
    }

    public void addKeyValue(SOAPElement keyvalue) throws XWSSecurityException {
        try {
            KeyValue kval = new KeyValue(keyvalue, null);
            this.delegateKeyInfo.add(kval);
            this.dirty = true;
        }
        catch (XMLSecurityException e) {
            log.log(Level.SEVERE, "WSS0355.error.creating.keyvalue", new Object[]{"", e.getMessage()});
            throw new XWSSecurityException(e);
        }
    }

    public void addMgmtData(String mgmtdata) {
        this.delegateKeyInfo.addMgmtData(mgmtdata);
        this.dirty = true;
    }

    public void addMgmtData(SOAPElement mgmtdata) throws XWSSecurityException {
        try {
            MgmtData mgmtData = new MgmtData(mgmtdata, null);
            this.delegateKeyInfo.add(mgmtData);
            this.dirty = true;
        }
        catch (XMLSecurityException e) {
            throw new XWSSecurityException(e);
        }
    }

    public void addPGPData(SOAPElement pgpdata) throws XWSSecurityException {
        try {
            PGPData pgpData = new PGPData(pgpdata, null);
            this.delegateKeyInfo.add(pgpData);
            this.dirty = true;
        }
        catch (XMLSecurityException e) {
            throw new XWSSecurityException(e);
        }
    }

    public void addRetrievalMethod(String URI2, Transforms transforms, String type) {
        this.delegateKeyInfo.addRetrievalMethod(URI2, transforms, type);
        this.dirty = true;
    }

    public void addRetrievalMethod(SOAPElement retrievalmethod) throws XWSSecurityException {
        try {
            RetrievalMethod rm = new RetrievalMethod(retrievalmethod, null);
            this.delegateKeyInfo.add(rm);
            this.dirty = true;
        }
        catch (XMLSecurityException e) {
            throw new XWSSecurityException(e);
        }
    }

    public void addSPKIData(SOAPElement spkidata) throws XWSSecurityException {
        try {
            SPKIData spki = new SPKIData(spkidata, null);
            this.delegateKeyInfo.add(spki);
            this.dirty = true;
        }
        catch (XMLSecurityException e) {
            throw new XWSSecurityException(e);
        }
    }

    public void addX509Data(SOAPElement x509data) throws XWSSecurityException {
        try {
            X509Data x509Data = new X509Data(x509data, null);
            this.delegateKeyInfo.add(x509Data);
            this.dirty = true;
        }
        catch (XMLSecurityException e) {
            log.log(Level.SEVERE, "WSS0356.error.creating.x509data", e.getMessage());
            throw new XWSSecurityException(e);
        }
    }

    public void addUnknownElement(SOAPElement element) {
        this.delegateKeyInfo.addUnknownElement(element);
        this.dirty = true;
    }

    public int keyNameCount() {
        return this.delegateKeyInfo.lengthKeyName();
    }

    public int keyValueCount() {
        return this.delegateKeyInfo.lengthKeyValue();
    }

    public int mgmtDataCount() {
        return this.delegateKeyInfo.lengthMgmtData();
    }

    public int pgpDataCount() {
        return this.delegateKeyInfo.lengthPGPData();
    }

    public int retrievalMethodCount() {
        return this.delegateKeyInfo.lengthRetrievalMethod();
    }

    public int spkiDataCount() {
        return this.delegateKeyInfo.lengthSPKIData();
    }

    public int x509DataCount() {
        return this.delegateKeyInfo.lengthX509Data();
    }

    public int unknownElementCount() {
        return this.delegateKeyInfo.lengthUnknownElement();
    }

    public SOAPElement getKeyName(int index) throws XWSSecurityException {
        try {
            return this.convertToSoapElement(this.delegateKeyInfo.itemKeyName(index));
        }
        catch (XMLSecurityException e) {
            log.log(Level.SEVERE, "WSS0320.exception.getting.keyname", e);
            throw new XWSSecurityException(e);
        }
    }

    public String getKeyNameString(int index) throws XWSSecurityException {
        try {
            return this.delegateKeyInfo.itemKeyName(index).getKeyName();
        }
        catch (XMLSecurityException e) {
            log.log(Level.SEVERE, "WSS0320.exception.getting.keyname", e);
            throw new XWSSecurityException(e);
        }
    }

    public SOAPElement getKeyValueElement(int index) throws XWSSecurityException {
        try {
            return this.convertToSoapElement(this.delegateKeyInfo.itemKeyValue(index));
        }
        catch (XMLSecurityException e) {
            throw new XWSSecurityException(e);
        }
    }

    public KeyValue getKeyValue(int index) throws XWSSecurityException {
        try {
            return this.delegateKeyInfo.itemKeyValue(index);
        }
        catch (XMLSecurityException e) {
            log.log(Level.SEVERE, "WSS0357.error.getting.keyvalue", new Object[]{index, e.getMessage()});
            throw new XWSSecurityException(e);
        }
    }

    public SOAPElement getMgmtData(int index) throws XWSSecurityException {
        try {
            return this.convertToSoapElement(this.delegateKeyInfo.itemMgmtData(index));
        }
        catch (XMLSecurityException e) {
            throw new XWSSecurityException(e);
        }
    }

    public SOAPElement getPGPData(int index) throws XWSSecurityException {
        try {
            return this.convertToSoapElement(this.delegateKeyInfo.itemPGPData(index));
        }
        catch (XMLSecurityException e) {
            throw new XWSSecurityException(e);
        }
    }

    public SOAPElement getRetrievalMethod(int index) throws XWSSecurityException {
        try {
            return this.convertToSoapElement(this.delegateKeyInfo.itemRetrievalMethod(index));
        }
        catch (XMLSecurityException e) {
            throw new XWSSecurityException(e);
        }
    }

    public SOAPElement getSPKIData(int index) throws XWSSecurityException {
        try {
            return this.convertToSoapElement(this.delegateKeyInfo.itemSPKIData(index));
        }
        catch (XMLSecurityException e) {
            throw new XWSSecurityException(e);
        }
    }

    public SOAPElement getX509DataElement(int index) throws XWSSecurityException {
        try {
            return this.convertToSoapElement(this.delegateKeyInfo.itemX509Data(index));
        }
        catch (XMLSecurityException e) {
            throw new XWSSecurityException(e);
        }
    }

    public X509Data getX509Data(int index) throws XWSSecurityException {
        try {
            return this.delegateKeyInfo.itemX509Data(index);
        }
        catch (XMLSecurityException e) {
            log.log(Level.SEVERE, "WSS0358.error.getting.x509data", new Object[]{index, e.getMessage()});
            throw new XWSSecurityException(e);
        }
    }

    public SOAPElement getUnknownElement(int index) throws XWSSecurityException {
        try {
            Element unknownElem = this.delegateKeyInfo.itemUnknownElement(index + 1);
            if (unknownElem instanceof SOAPElement) {
                return (SOAPElement)unknownElem;
            }
            return (SOAPElement)this.document.importNode(unknownElem, true);
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
    }

    public boolean containsKeyName() {
        return this.delegateKeyInfo.containsKeyName();
    }

    public boolean containsKeyValue() {
        return this.delegateKeyInfo.containsKeyValue();
    }

    public boolean containsMgmtData() {
        return this.delegateKeyInfo.containsMgmtData();
    }

    public boolean containsPGPData() {
        return this.delegateKeyInfo.containsPGPData();
    }

    public boolean containsRetrievalMethod() {
        return this.delegateKeyInfo.containsRetrievalMethod();
    }

    public boolean containsSPKIData() {
        return this.delegateKeyInfo.containsSPKIData();
    }

    public boolean containsUnknownElement() {
        return this.delegateKeyInfo.containsUnknownElement();
    }

    public boolean containsX509Data() {
        return this.delegateKeyInfo.containsX509Data();
    }

    public void addSecurityTokenReference(SecurityTokenReference reference) throws XWSSecurityException {
        this.delegateKeyInfo.addUnknownElement(reference.getAsSoapElement());
        this.dirty = true;
    }

    public SecurityTokenReference getSecurityTokenReference(int index) throws XWSSecurityException {
        Element delegateElement = this.delegateKeyInfo.getElement();
        int res = 0;
        NodeList nl = delegateElement.getChildNodes();
        for (int j = 0; j < nl.getLength(); ++j) {
            Node current = nl.item(j);
            if (current.getNodeType() != 1) continue;
            String lName = current.getLocalName();
            String nspac = current.getNamespaceURI();
            if (!lName.equals("SecurityTokenReference") || !nspac.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd")) continue;
            if (res == index) {
                return new SecurityTokenReference((SOAPElement)current);
            }
            ++res;
        }
        return null;
    }

    public int securityTokenReferenceCount() {
        Element delegateElement = this.delegateKeyInfo.getElement();
        int res = 0;
        NodeList nl = delegateElement.getChildNodes();
        for (int j = 0; j < nl.getLength(); ++j) {
            Node current = nl.item(j);
            if (current.getNodeType() != 1 || !"SecurityTokenReference".equals(current.getLocalName()) || !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(current.getNamespaceURI())) continue;
            ++res;
        }
        return res;
    }

    public boolean containsSecurityTokenReference() {
        return this.securityTokenReferenceCount() > 0;
    }

    public void addEncryptedKey(EncryptedKeyToken reference) {
        this.delegateKeyInfo.addUnknownElement(reference.getAsSoapElement());
        this.dirty = true;
    }

    public EncryptedKeyToken getEncryptedKey(int index) {
        Element delegateElement = this.delegateKeyInfo.getElement();
        int res = 0;
        NodeList nl = delegateElement.getChildNodes();
        for (int j = 0; j < nl.getLength(); ++j) {
            Node current = nl.item(j);
            if (current.getNodeType() != 1) continue;
            String lName = current.getLocalName();
            String nspac = current.getNamespaceURI();
            if (!lName.equals("EncryptedKey") || !nspac.equals("http://www.w3.org/2001/04/xmlenc#")) continue;
            if (res == index) {
                return new EncryptedKeyToken((SOAPElement)current);
            }
            ++res;
        }
        return null;
    }

    public int encryptedKeyTokenCount() {
        Element delegateElement = this.delegateKeyInfo.getElement();
        int res = 0;
        NodeList nl = delegateElement.getChildNodes();
        for (int j = 0; j < nl.getLength(); ++j) {
            Node current = nl.item(j);
            if (current.getNodeType() != 1 || !"EncryptedKey".equals(current.getLocalName()) || !"http://www.w3.org/2001/04/xmlenc#".equals(current.getNamespaceURI())) continue;
            ++res;
        }
        return res;
    }

    public boolean containsEncryptedKeyToken() {
        return this.encryptedKeyTokenCount() > 0;
    }

    public BinarySecret getBinarySecret(int index) throws XWSSecurityException {
        Element delegateElement = this.delegateKeyInfo.getElement();
        int res = 0;
        NodeList nl = delegateElement.getChildNodes();
        for (int j = 0; j < nl.getLength(); ++j) {
            Node current = nl.item(j);
            if (current.getNodeType() != 1) continue;
            String lName = current.getLocalName();
            String nspac = current.getNamespaceURI();
            if (!lName.equals("BinarySecret") || !nspac.equals("http://schemas.xmlsoap.org/ws/2005/02/trust")) continue;
            if (res == index) {
                try {
                    return WSTrustElementFactory.newInstance().createBinarySecret((SOAPElement)current);
                }
                catch (WSTrustException ex) {
                    throw new XWSSecurityException(ex);
                }
            }
            ++res;
        }
        return null;
    }

    public int binarySecretCount() {
        Element delegateElement = this.delegateKeyInfo.getElement();
        int res = 0;
        NodeList nl = delegateElement.getChildNodes();
        for (int j = 0; j < nl.getLength(); ++j) {
            Node current = nl.item(j);
            if (current.getNodeType() != 1 || !"BinarySecret".equals(current.getLocalName()) || !"http://schemas.xmlsoap.org/ws/2005/02/trust".equals(current.getNamespaceURI())) continue;
            ++res;
        }
        return res;
    }

    public boolean containsBinarySecret() {
        return this.binarySecretCount() > 0;
    }

    public void setId(String id) {
        this.delegateKeyInfo.setId(id);
    }

    @Override
    public String getId() {
        return this.delegateKeyInfo.getId();
    }

    public final KeyInfo getKeyInfo() {
        return this.delegateKeyInfo;
    }

    public void setBaseURI(String uri) {
        this.baseURI = uri;
    }

    @Override
    public SOAPElement getAsSoapElement() throws XWSSecurityException {
        if (this.document == null) {
            throw new XWSSecurityException("Document not set");
        }
        if (this.dirty) {
            this.setSOAPElement(this.convertToSoapElement(this.delegateKeyInfo));
            this.dirty = false;
        }
        return this.delegateElement;
    }

    public void setDocument(Document doc) {
        this.document = doc;
    }

    public KeyInfoHeaderBlock(SOAPElement element) throws XWSSecurityException {
        super(element);
        try {
            this.document = element.getOwnerDocument();
            this.delegateKeyInfo = new KeyInfo(element, this.baseURI);
        }
        catch (XMLSecurityException e) {
            log.log(Level.SEVERE, "WSS0318.exception.while.creating.keyinfoblock", e);
            throw new XWSSecurityException(e);
        }
    }

    public void saveChanges() {
        this.dirty = true;
    }

    public static SecurityHeaderBlock fromSoapElement(SOAPElement element) throws XWSSecurityException {
        return SecurityHeaderBlockImpl.fromSoapElement(element, KeyInfoHeaderBlock.class);
    }

    private SOAPElement convertToSoapElement(ElementProxy proxy) throws XWSSecurityException {
        try {
            Element elem = proxy.getElement();
            if (elem instanceof SOAPElement) {
                return (SOAPElement)elem;
            }
            return (SOAPElement)this.document.importNode(elem, true);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0321.exception.converting.keyinfo.tosoapelem", e);
            throw new XWSSecurityException(e);
        }
    }

    public void addX509Data(X509Data x509Data) throws XWSSecurityException {
        try {
            this.delegateKeyInfo.add(x509Data);
            this.dirty = true;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0359.error.adding.x509data", e.getMessage());
            throw new XWSSecurityException(e);
        }
    }
}

