/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.saml.assertion.saml20.jaxb20;

import com.sun.xml.security.core.dsig.KeyInfoType;
import com.sun.xml.wss.logging.LogStringsMessages;
import com.sun.xml.wss.saml.SAMLException;
import com.sun.xml.wss.saml.internal.saml20.jaxb20.KeyInfoConfirmationDataType;
import com.sun.xml.wss.saml.util.SAML20JAXBUtil;
import com.sun.xml.wss.saml.util.SAMLJAXBUtil;
import com.sun.xml.wss.util.DateUtils;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.Unmarshaller;
import java.security.PublicKey;
import java.text.ParseException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class KeyInfoConfirmationData
extends KeyInfoConfirmationDataType
implements com.sun.xml.wss.saml.KeyInfoConfirmationData {
    protected PublicKey keyInfoKeyValue = null;
    protected static final Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    public static KeyInfoConfirmationData fromElement(Element element) throws SAMLException {
        try {
            JAXBContext jc = SAML20JAXBUtil.getJAXBContext();
            Unmarshaller u = jc.createUnmarshaller();
            return (KeyInfoConfirmationData)u.unmarshal(element);
        }
        catch (Exception ex) {
            throw new SAMLException(ex.getMessage());
        }
    }

    public KeyInfoConfirmationData(Element keyInfo) throws SAMLException {
        JAXBContext jc = null;
        Unmarshaller u = null;
        try {
            jc = SAMLJAXBUtil.getJAXBContext();
            u = jc.createUnmarshaller();
        }
        catch (Exception ex) {
            throw new SAMLException(ex.getMessage());
        }
        try {
            if (keyInfo != null) {
                this.setKeyInfo((KeyInfoType)((JAXBElement)u.unmarshal(keyInfo)).getValue());
            }
        }
        catch (Exception ex) {
            throw new SAMLException(ex);
        }
    }

    public void setKeyInfo(KeyInfoType value) {
        this.getContent().add(value);
    }

    @Override
    public Date getNotBeforeDate() {
        if (super.getNotBefore() != null) {
            Date getNotBeforeDate = null;
            try {
                getNotBeforeDate = DateUtils.stringToDate(super.getNotBefore().toString());
            }
            catch (ParseException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WSS_0430_SAML_GET_NOT_BEFORE_DATE_OR_GET_NOT_ON_OR_AFTER_DATE_PARSE_FAILED(), ex);
            }
            return getNotBeforeDate;
        }
        return null;
    }

    @Override
    public Date getNotOnOrAfterDate() {
        if (super.getNotBefore() != null) {
            Date getNotBeforeDate = null;
            try {
                getNotBeforeDate = DateUtils.stringToDate(super.getNotOnOrAfter().toString());
            }
            catch (ParseException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WSS_0430_SAML_GET_NOT_BEFORE_DATE_OR_GET_NOT_ON_OR_AFTER_DATE_PARSE_FAILED(), ex);
            }
            return getNotBeforeDate;
        }
        return null;
    }
}

