/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.core.util.soap;

import de.latlon.ets.core.util.TestSuiteLogger;
import jakarta.xml.soap.MessageFactory;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.soap.SOAPPart;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class SoapUtils {
    private SoapUtils() {
    }

    public static Source readPayloadFromFile(InputStream resourceAsStream) {
        if (resourceAsStream == null) {
            throw new IllegalArgumentException("InputStream must not be null");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(resourceAsStream);
        }
        catch (ParserConfigurationException e) {
            TestSuiteLogger.log(Level.SEVERE, "Failed to parse document", e);
        }
        catch (IOException | SAXException e) {
            TestSuiteLogger.log(Level.SEVERE, "Failed to read from stream", e);
        }
        return new DOMSource(document);
    }

    public static SOAPPart convertToSoapPart(Source source) throws SOAPException {
        MessageFactory factory = MessageFactory.newInstance("SOAP 1.1 Protocol");
        SOAPMessage message = factory.createMessage();
        SOAPPart soapPart = message.getSOAPPart();
        soapPart.setContent(source);
        return soapPart;
    }
}

