/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wms13.core;

import de.latlon.ets.core.util.TestSuiteLogger;
import de.latlon.ets.core.util.URIUtils;
import de.latlon.ets.wms13.core.TestRunArg;
import de.latlon.ets.wms13.core.domain.InteractiveTestResult;
import de.latlon.ets.wms13.core.domain.SuiteAttribute;
import de.latlon.ets.wms13.core.util.ServiceMetadataUtils;
import java.io.File;
import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.Reporter;
import org.w3c.dom.Document;

public class SuiteFixtureListener
implements ISuiteListener {
    @Override
    public void onStart(ISuite suite) {
        this.processWmsParameter(suite);
        Reporter.clear();
        StringBuilder str = new StringBuilder("Initial test run parameters:\n");
        str.append(suite.getXmlSuite().getAllParameters().toString());
        Reporter.log(str.toString());
        TestSuiteLogger.log(Level.CONFIG, str.toString());
    }

    @Override
    public void onFinish(ISuite suite) {
        Reporter.log("Success? " + !suite.getSuiteState().isFailed());
        String reportDir = suite.getOutputDirectory();
        String msg = String.format("Test run directory: %s", reportDir.substring(0, reportDir.lastIndexOf(File.separatorChar)));
        Reporter.log(msg);
    }

    void processWmsParameter(ISuite suite) {
        Map<String, String> params = suite.getXmlSuite().getParameters();
        String wmsRef = params.get(TestRunArg.WMS.toString());
        if (null == wmsRef || wmsRef.isEmpty()) {
            throw new IllegalArgumentException("Required parameter not found");
        }
        URI wmsURI = URI.create(wmsRef);
        Document doc = null;
        try {
            doc = URIUtils.resolveURIAsDocument(wmsURI);
            if (!"WMS_Capabilities".equals(doc.getDocumentElement().getLocalName())) {
                throw new RuntimeException("Did not receive WMS capabilities document: " + doc.getDocumentElement().getNodeName());
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to parse resource located at " + wmsURI, ex);
        }
        if (null != doc) {
            suite.setAttribute(SuiteAttribute.TEST_SUBJECT.getName(), doc);
            suite.setAttribute(SuiteAttribute.LAYER_INFO.getName(), ServiceMetadataUtils.parseLayerInfo(doc));
            suite.setAttribute(SuiteAttribute.IS_VECTOR.getName(), this.parseBoolean(params, TestRunArg.VECTOR));
            suite.setAttribute(SuiteAttribute.INTERACTIVE_TEST_RESULT.getName(), this.parseInteractiveTestResults(params));
        }
    }

    private Object parseInteractiveTestResults(Map<String, String> params) {
        boolean capabilitiesInEnglishLanguage = this.parseBoolean(params, TestRunArg.CAPABILITIES_IN_ENGLISH);
        boolean getFeatureInfoInEnglishLanguage = this.parseBoolean(params, TestRunArg.GETFEATUREINFO_IN_ENGLISH);
        boolean getFeatureInfoExceptionInEnglishLanguage = this.parseBoolean(params, TestRunArg.GETFEATUREINFO_EXCEPTION_IN_ENGLISH);
        boolean getMapExceptionInEnglishLanguage = this.parseBoolean(params, TestRunArg.GETMAP_EXCEPTION_IN_ENGLISH);
        return new InteractiveTestResult(capabilitiesInEnglishLanguage, getFeatureInfoInEnglishLanguage, getFeatureInfoExceptionInEnglishLanguage, getMapExceptionInEnglishLanguage);
    }

    private boolean parseBoolean(Map<String, String> params, TestRunArg arg) {
        String key = arg.toString();
        if (params.containsKey(key)) {
            String vectorParam = params.get(key);
            return Boolean.parseBoolean(vectorParam);
        }
        return false;
    }
}

