/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wms13.core.client;

import de.latlon.ets.core.util.XMLUtils;
import de.latlon.ets.wms13.core.client.WmsKvpRequest;
import de.latlon.ets.wms13.core.domain.ProtocolBinding;
import de.latlon.ets.wms13.core.util.SOAPMessageConsumer;
import de.latlon.ets.wms13.core.util.ServiceMetadataUtils;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import org.apache.tika.io.FilenameUtils;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.logging.LoggingFeature;
import org.w3c.dom.Document;

public class WmsClient {
    private static final Logger LOGR = Logger.getLogger(WmsClient.class.getPackage().getName());
    private Client client;
    private Document wmsCapabilities;

    public WmsClient(Document wmsCapabilities) {
        ClientConfig config = new ClientConfig();
        config.property("jersey.config.client.followRedirects", true);
        config.property("jersey.config.client.connectTimeout", 10000);
        config.register(new LoggingFeature(LOGR, Level.ALL, LoggingFeature.Verbosity.PAYLOAD_ANY, 5000));
        config.register((Class)SOAPMessageConsumer.class);
        this.client = ClientBuilder.newClient(config);
        this.wmsCapabilities = wmsCapabilities;
    }

    public Document getCapabilities() {
        if (null == this.wmsCapabilities) {
            throw new IllegalStateException("Service description is unavailable.");
        }
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wmsCapabilities, "GetCapabilities", ProtocolBinding.GET);
        if (null == endpoint) {
            throw new RuntimeException("GetCapabilities (GET) endpoint not found in capabilities document.");
        }
        MultivaluedHashMap<String, String> queryParams = new MultivaluedHashMap<String, String>();
        queryParams.add("request", "GetCapabilities");
        queryParams.add("service", "WMS");
        queryParams.add("version", "1.3.0");
        UriBuilder uriBuilder = UriBuilder.fromUri(endpoint);
        if (null != queryParams) {
            for (Map.Entry param : queryParams.entrySet()) {
                uriBuilder.queryParam((String)param.getKey(), ((List)param.getValue()).get(0));
            }
        }
        URI uri = uriBuilder.build(new Object[0]);
        WebTarget target = this.client.target(uri);
        Invocation.Builder reqBuilder = target.request();
        return reqBuilder.buildGet().invoke().readEntity(Document.class);
    }

    public Response submitRequest(WmsKvpRequest request, URI endpoint) {
        WebTarget target = this.client.target(endpoint);
        return this.submitGetRequest(target, request);
    }

    public Response submitRequest(Source payload, URI endpoint) {
        if (payload == null || endpoint == null) {
            throw new IllegalArgumentException("Neither payload nor endpoint must be null");
        }
        WebTarget target = this.client.target(endpoint);
        return this.submitPostRequest(target, payload);
    }

    private Response submitPostRequest(WebTarget target, Source payload) {
        LOGR.log(Level.FINE, String.format("Submitting POST request to URI %s", target.getUri()));
        LOGR.log(Level.FINE, String.format("Request Payload: %s", XMLUtils.transformToString(payload)));
        Response response = null;
        try {
            response = target.request("application/soap+xml").buildPost(Entity.entity(payload, "application/soap+xml")).invoke();
            if (LOGR.isLoggable(Level.FINE)) {
                LOGR.log(Level.FINE, String.format("SOAP Response: %s", FilenameUtils.normalize(response.toString())));
            }
        }
        catch (ProcessingException ex) {
            LOGR.log(Level.SEVERE, "Failed to process SOAP request/response: " + target.getUri(), ex);
        }
        return response;
    }

    private Response submitGetRequest(WebTarget target, WmsKvpRequest requestParameter) {
        LOGR.log(Level.FINE, String.format("Submitting GET request to URI %s", target.getUri()));
        String queryString = requestParameter.asQueryString();
        URI requestURI = UriBuilder.fromUri(target.getUri()).replaceQuery(queryString).build(new Object[0]);
        LOGR.log(Level.FINE, String.format("Request URI: %s", requestURI));
        target = this.client.target(requestURI);
        Invocation.Builder reqBuilder = target.request();
        Invocation req = reqBuilder.buildGet();
        return req.invoke();
    }
}

