/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wms13.core.dgiwg.testsuite;

import de.latlon.ets.core.util.XMLUtils;
import de.latlon.ets.wms13.core.TestRunArg;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trans.XPathException;
import org.glassfish.jersey.client.ClientConfig;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class QueryableWMS {
    private static final Logger LOGR = Logger.getLogger(QueryableWMS.class.getPackage().getName());
    private Level logLevel = Level.INFO;
    private static final URI DEFAULT_TES = URI.create("http://cite.opengeospatial.org/te2/");
    private static final String HTML_NS = "http://www.w3.org/1999/xhtml";
    private static final String CAPABILITIES_URL = "capabilities-url";
    private static final String QUERYABLE = "queryable";
    private Client httpClient;
    private URI baseTestRunController;
    private String wmsCapabilitiesRef;

    @BeforeTest
    public void initTestFixture(ITestContext testContext) {
        ClientConfig config = new ClientConfig();
        this.httpClient = ClientBuilder.newClient(config);
        this.wmsCapabilitiesRef = testContext.getSuite().getParameter(TestRunArg.WMS.toString());
    }

    @BeforeClass
    public void discoverBaseControllerEndpoint(ITestContext testContext) {
        String tes = testContext.getSuite().getParameter(TestRunArg.TES.toString());
        if (null != tes && !tes.isEmpty()) {
            try {
                URI altTestExecService = new URI(tes);
                this.baseTestRunController = this.discoverTestRunController(altTestExecService);
            }
            catch (URISyntaxException e1) {
                LOGR.info(String.format("Value of test run argument '%s' is not a valid URI: %s", TestRunArg.TES.toString(), tes));
            }
            catch (RuntimeException e2) {
                LOGR.info(e2.getMessage());
            }
        }
        if (null == this.baseTestRunController) {
            try {
                this.baseTestRunController = this.discoverTestRunController(DEFAULT_TES);
            }
            catch (RuntimeException e) {
                LOGR.warning("WMS controller endpoint not available. " + e.getMessage());
                throw new SkipException(e.getMessage());
            }
        }
        LOGR.info("Using WMS controller endpoint at " + this.baseTestRunController.toString());
    }

    @Test(enabled=false, description="See DGIWG-112: Table 1, Requirement 1")
    public void invokeBaseTestSuite() throws IOException {
        XdmNode mainTestNode;
        LOGR.log(this.logLevel, "Starting base test run at {0}", this.baseTestRunController);
        MultivaluedHashMap<String, String> args = new MultivaluedHashMap<String, String>();
        args.putSingle(CAPABILITIES_URL, this.wmsCapabilitiesRef);
        args.putSingle(QUERYABLE, QUERYABLE);
        UriBuilder uriBuilder = UriBuilder.fromUri(this.baseTestRunController);
        if (null != args) {
            for (Map.Entry param : args.entrySet()) {
                uriBuilder.queryParam((String)param.getKey(), param.getValue());
            }
        }
        URI uri = uriBuilder.build(new Object[0]);
        WebTarget target = this.httpClient.target(uri);
        Invocation.Builder reqBuilder = target.request().accept("application/xml");
        Response rsp = reqBuilder.buildGet().invoke();
        Assert.assertEquals(rsp.getStatus(), Response.Status.OK.getStatusCode(), "Unexpected status code.");
        LOGR.log(this.logLevel, "Test run was completed.");
        Assert.assertTrue(rsp.hasEntity(), "No entity in response from test run controller.");
        File results = this.saveEntityToFile(rsp);
        LOGR.log(this.logLevel, "Test run results were saved to {0}", results);
        try {
            XdmValue xdmVal = XMLUtils.evaluateXPath2(new StreamSource(results), "/execution/log[1]", null);
            mainTestNode = (XdmNode)xdmVal.itemAt(0);
        }
        catch (SaxonApiException e) {
            throw new AssertionError((Object)e.getMessage());
        }
        XdmNode startTest = (XdmNode)mainTestNode.axisIterator(Axis.CHILD, new QName("starttest")).next();
        LOGR.log(this.logLevel, "Base test run identifier: {0}", startTest.getAttributeValue(new QName("path")));
        XdmNode endTest = (XdmNode)mainTestNode.axisIterator(Axis.CHILD, new QName("endtest")).next();
        int statusCode = Integer.parseInt(endTest.getAttributeValue(new QName("result")));
        TestVerdict mainVerdict = TestVerdict.values()[statusCode - 1];
        Assert.assertEquals((Object)mainVerdict, (Object)TestVerdict.PASS, "Unexpected verdict for main test.");
    }

    File saveEntityToFile(Response rsp) throws IOException {
        File destFile = File.createTempFile("wmsResults-", ".xml");
        try (InputStream in = rsp.readEntity(InputStream.class);
             FileOutputStream out = new FileOutputStream(destFile);){
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = in.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, bytesRead);
            }
        }
        return destFile;
    }

    URI discoverTestRunController(URI testEndpoint) {
        XdmValue xdmVal;
        URI targetURI = UriBuilder.fromUri(testEndpoint).path("rest/suites/").build(new Object[0]);
        WebTarget target = this.httpClient.target(testEndpoint);
        Invocation.Builder reqBuilder = target.request();
        Response rsp = reqBuilder.buildGet().invoke();
        if (!rsp.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
            throw new RuntimeException(String.format("Test execution service not available at %s", testEndpoint));
        }
        String xpath = "//html:li/html:a[starts-with(@id,'wms')]/@href";
        StreamSource entity = new StreamSource(rsp.readEntity(InputStream.class), targetURI.toString());
        try {
            xdmVal = XMLUtils.evaluateXPath2(entity, xpath, Collections.singletonMap(HTML_NS, "html"));
        }
        catch (SaxonApiException e) {
            throw new RuntimeException(String.format("Failed to access list of test suites at %s. Reason: %s", targetURI, e.getMessage()));
        }
        if (xdmVal.size() == 0) {
            throw new RuntimeException(String.format("WMS test suite is not listed at %s", targetURI));
        }
        URI controllerUri = null;
        try {
            String etsPath = xdmVal.getUnderlyingValue().getStringValue();
            controllerUri = UriBuilder.fromUri(targetURI).path(etsPath).path("run").build(new Object[0]);
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
        return controllerUri;
    }

    static enum TestVerdict {
        PASS,
        NOT_TESTED,
        SKIP,
        WARNING,
        INHERITED_FAILURE,
        FAIL;

    }
}

