/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wms13.core.dgiwg.testsuite.getfeatureinfo;

import de.latlon.ets.core.assertion.ETSAssert;
import de.latlon.ets.core.error.ErrorMessage;
import de.latlon.ets.core.error.ErrorMessageKey;
import de.latlon.ets.wms13.core.dgiwg.testsuite.getfeatureinfo.BaseGetFeatureInfoFixture;
import de.latlon.ets.wms13.core.domain.ProtocolBinding;
import de.latlon.ets.wms13.core.util.ServiceMetadataUtils;
import jakarta.ws.rs.core.Response;
import jakarta.xml.soap.SOAPException;
import java.net.URI;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class GetFeatureInfoInfoFormatTest
extends BaseGetFeatureInfoFixture {
    @DataProvider(name="supportedFormats")
    public Object[][] parseSupportedFormats(ITestContext testContext) throws XPathFactoryConfigurationException, XPathExpressionException {
        List<String> formats = ServiceMetadataUtils.parseSupportedFormats(this.wmsCapabilities, "GetFeatureInfo");
        Object[][] supportedFormats = new Object[formats.size()][];
        for (int indexOfFormat = 0; indexOfFormat < supportedFormats.length; ++indexOfFormat) {
            supportedFormats[indexOfFormat] = new Object[]{formats.get(indexOfFormat)};
        }
        return supportedFormats;
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.6.6, S.22, Requirement 31", dataProvider="supportedFormats")
    public void wmsGetFeatureInfoInfoFormatWithAllValuesOfCapabilities(String supportedFormat) throws SOAPException, XPathExpressionException, XPathFactoryConfigurationException {
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wmsCapabilities, "GetFeatureInfo", ProtocolBinding.GET);
        this.reqEntity.addKvp("INFO_FORMAT", supportedFormat);
        Response rsp = this.wmsClient.submitRequest(this.reqEntity, endpoint);
        Assert.assertTrue(rsp.hasEntity(), ErrorMessage.get(ErrorMessageKey.MISSING_XML_ENTITY));
        ETSAssert.assertContentType(rsp.getHeaders(), supportedFormat);
    }
}

