/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wms13.core.dgiwg.testsuite.getfeatureinfo;

import de.latlon.ets.core.assertion.ETSAssert;
import de.latlon.ets.core.error.ErrorMessage;
import de.latlon.ets.core.error.ErrorMessageKey;
import de.latlon.ets.wms13.core.dgiwg.testsuite.getfeatureinfo.BaseGetFeatureInfoFixture;
import de.latlon.ets.wms13.core.domain.ProtocolBinding;
import de.latlon.ets.wms13.core.util.ServiceMetadataUtils;
import jakarta.ws.rs.core.Response;
import jakarta.xml.soap.SOAPException;
import java.net.URI;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class GetFeatureInfoOutputFormatTest
extends BaseGetFeatureInfoFixture {
    @BeforeMethod
    public void clearRequest() {
        this.reqEntity.removeKvp("INFO_FORMAT");
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.5.3.1., S.9, Requirement 3")
    public void wmsCapabilitiesOutputFormatTextXmlSupported() throws SOAPException {
        String xPathXml = "//wms:WMS_Capabilities/wms:Capability/wms:Request/wms:GetFeatureInfo/wms:Format/text() = 'text/xml'";
        ETSAssert.assertXPath(xPathXml, this.wmsCapabilities, NS_BINDINGS);
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.5.3.1., S.9, Requirement 3")
    public void wmsCapabilitiesOutputFormatTextHtmlSupported() throws SOAPException {
        String xPathHtml = "//wms:WMS_Capabilities/wms:Capability/wms:Request/wms:GetFeatureInfo/wms:Format/text() = 'text/html'";
        ETSAssert.assertXPath(xPathHtml, this.wmsCapabilities, NS_BINDINGS);
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.5.3.1., S.9, Requirement 3", dependsOnMethods={"wmsCapabilitiesOutputFormatTextXmlSupported"})
    public void wmsGetFeatureInfoOutputFormatTextXmlSupported() throws SOAPException {
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wmsCapabilities, "GetFeatureInfo", ProtocolBinding.GET);
        this.reqEntity.addKvp("INFO_FORMAT", "text/xml");
        Response rsp = this.wmsClient.submitRequest(this.reqEntity, endpoint);
        Assert.assertTrue(rsp.hasEntity(), ErrorMessage.get(ErrorMessageKey.MISSING_XML_ENTITY));
        ETSAssert.assertContentType(rsp.getHeaders(), "text/xml");
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.5.3.1., S.9, Requirement 3", dependsOnMethods={"wmsCapabilitiesOutputFormatTextHtmlSupported"})
    public void wmsGetFeatureInfoOutputFormatTextHtmlSupported() throws SOAPException {
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wmsCapabilities, "GetFeatureInfo", ProtocolBinding.GET);
        this.reqEntity.addKvp("INFO_FORMAT", "text/html");
        Response rsp = this.wmsClient.submitRequest(this.reqEntity, endpoint);
        Assert.assertTrue(rsp.hasEntity(), ErrorMessage.get(ErrorMessageKey.MISSING_XML_ENTITY));
        ETSAssert.assertContentType(rsp.getHeaders(), "text/html");
    }
}

