/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wms13.core.dgiwg.testsuite.getmap;

import de.latlon.ets.core.util.TestSuiteLogger;
import de.latlon.ets.wms13.core.dgiwg.testsuite.AbstractBaseGetFixture;
import de.latlon.ets.wms13.core.util.request.WmsRequestBuilder;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.logging.Level;
import org.apache.tika.io.FilenameUtils;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;

public class BaseGetMapFixture
extends AbstractBaseGetFixture {
    static final String SUBDIRECTORY = "GetMapTests";
    private Path imageDirectory;

    @BeforeClass
    public void buildGetMapRequest() {
        this.reqEntity = WmsRequestBuilder.buildGetMapRequest(this.wmsCapabilities, this.layerInfo);
    }

    @BeforeClass
    public void setResultDirectory(ITestContext testContext) {
        String outputDirectory = this.retrieveSessionDir(testContext);
        TestSuiteLogger.log(Level.INFO, "Directory to store GetMap responses: " + outputDirectory);
        try {
            Path resultDir = Paths.get(outputDirectory, new String[0]);
            this.imageDirectory = this.createDirectory(resultDir, SUBDIRECTORY);
        }
        catch (IOException e) {
            TestSuiteLogger.log(Level.WARNING, "Could not create directory for GetMap response.", e);
        }
    }

    protected String findRequiredImageFormatWithTransparencySupport() {
        String imageFormat = WmsRequestBuilder.getSupportedTransparentFormat(this.wmsCapabilities, "GetMap");
        if (imageFormat == null) {
            throw new SkipException("WMS does not support an image format supporting transparency.");
        }
        return imageFormat;
    }

    protected void storeResponseImage(Response rsp, String testGroup, String testName, String requestFormat) {
        if (this.imageDirectory == null) {
            TestSuiteLogger.log(Level.WARNING, "Directory to store GetMap responses is not set. GetMap response is not written!");
            return;
        }
        this.writeIntoFile(rsp, testGroup, testName, requestFormat);
    }

    private void writeIntoFile(Response rsp, String testGroup, String testName, String requestFormat) {
        try {
            Path testClassDirectory = this.createDirectory(this.imageDirectory, testGroup);
            InputStream imageStream = rsp.readEntity(InputStream.class);
            String fileExtension = this.detectFileExtension(requestFormat);
            Object fileName = testName + fileExtension;
            fileName = FilenameUtils.normalize((String)fileName);
            Path imageFile = testClassDirectory.resolve((String)fileName);
            Files.copy(imageStream, imageFile, new CopyOption[0]);
        }
        catch (IOException | MimeTypeException e) {
            TestSuiteLogger.log(Level.WARNING, "Writing the GetMap response into file failed.", e);
        }
    }

    private String detectFileExtension(String requestFormat) throws MimeTypeException {
        MimeTypes allTypes = MimeTypes.getDefaultMimeTypes();
        MimeType mimeType = allTypes.forName(requestFormat);
        return mimeType.getExtension();
    }

    private Path createDirectory(Path parent, String child) throws IOException {
        Path testClassDirectory = parent.resolve(child);
        Files.createDirectories(testClassDirectory, new FileAttribute[0]);
        return testClassDirectory;
    }

    String retrieveSessionDir(ITestContext testContext) {
        UUID testRunId;
        String outputDirectory = testContext.getOutputDirectory();
        File outputDir = new File(outputDirectory);
        try {
            testRunId = UUID.fromString(outputDir.getName());
        }
        catch (IllegalArgumentException e) {
            outputDir = outputDir.getParentFile();
            testRunId = UUID.fromString(outputDir.getName());
        }
        if (null == testRunId) {
            throw new RuntimeException("Unable to locate test run output directory: " + outputDirectory);
        }
        return outputDir.getPath();
    }
}

