/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wms13.core.dgiwg.testsuite.getmap;

import de.latlon.ets.core.assertion.ETSAssert;
import de.latlon.ets.core.error.ErrorMessage;
import de.latlon.ets.core.error.ErrorMessageKey;
import de.latlon.ets.wms13.core.dgiwg.testsuite.getmap.BaseGetMapFixture;
import de.latlon.ets.wms13.core.domain.BoundingBox;
import de.latlon.ets.wms13.core.domain.Dimension;
import de.latlon.ets.wms13.core.domain.LayerInfo;
import de.latlon.ets.wms13.core.domain.ProtocolBinding;
import de.latlon.ets.wms13.core.util.ServiceMetadataUtils;
import de.latlon.ets.wms13.core.util.request.WmsRequestBuilder;
import jakarta.ws.rs.core.Response;
import jakarta.xml.soap.SOAPException;
import java.net.URI;
import java.util.List;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.testng.internal.collections.Pair;

public class GetMapDimensionsTest
extends BaseGetMapFixture {
    @BeforeMethod
    public void clearRequest() {
        this.reqEntity.removeKvp("FORMAT");
        this.reqEntity.removeKvp("LAYERS");
        this.reqEntity.removeKvp("CRS");
        this.reqEntity.removeKvp("BBOX");
        this.reqEntity.removeKvp("FORMAT");
        this.reqEntity.removeKvp("TRANSPARENT");
        this.reqEntity.removeKvp("BGCOLOR");
        this.reqEntity.removeKvp("EXCEPTIONS");
        this.reqEntity.removeKvp("ELEVATION");
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.6.3., S.20, Requirement 28")
    public void wmsGetMapDimensionsSupported(ITestContext testContext) throws SOAPException {
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wmsCapabilities, "GetMap", ProtocolBinding.GET);
        String requestFormat = WmsRequestBuilder.getSupportedTransparentFormat(this.wmsCapabilities, "GetMap");
        Pair<LayerInfo, Dimension> layerInfoAndDimension = this.findLayerWithDimension(this.layerInfo);
        LayerInfo layerInfoWithDimension = layerInfoAndDimension.first();
        BoundingBox bbox = WmsRequestBuilder.findBoundingBox(layerInfoWithDimension);
        String dimensionParameterValue = this.findParameterValue(layerInfoAndDimension);
        this.reqEntity.addKvp("FORMAT", requestFormat);
        this.reqEntity.addKvp("LAYERS", layerInfoWithDimension.getLayerName());
        this.reqEntity.addKvp("CRS", bbox.getCrs());
        this.reqEntity.addKvp("BBOX", bbox.getBboxAsString());
        this.reqEntity.addKvp("TRANSPARENT", "TRUE");
        this.reqEntity.addKvp("BGCOLOR", "0xFFFFFF");
        this.reqEntity.addKvp("EXCEPTIONS", "XML");
        this.reqEntity.addKvp("DIMENSION", dimensionParameterValue);
        Response rsp = this.wmsClient.submitRequest(this.reqEntity, endpoint);
        Assert.assertTrue(rsp.hasEntity(), ErrorMessage.get(ErrorMessageKey.MISSING_XML_ENTITY));
        this.storeResponseImage(rsp, "Requirement28", "dimensions", requestFormat);
        ETSAssert.assertStatusCode(rsp.getStatus(), 200);
        ETSAssert.assertContentType(rsp.getHeaders(), requestFormat);
    }

    private Pair<LayerInfo, Dimension> findLayerWithDimension(List<LayerInfo> layerInfos) {
        for (LayerInfo layerInfo : layerInfos) {
            List<Dimension> dimensions = layerInfo.getDimensions();
            for (Dimension dimension : dimensions) {
                if ("elevation".equalsIgnoreCase(dimension.getName()) || "time".equalsIgnoreCase(dimension.getName())) continue;
                return new Pair<LayerInfo, Dimension>(layerInfo, dimension);
            }
        }
        throw new SkipException("No layer with dimension (not 'time' or 'elevation') supported!");
    }

    private String findParameterValue(Pair<LayerInfo, Dimension> layerInfoAndDimension) {
        Dimension dimension = layerInfoAndDimension.second();
        return dimension.getDimensionValue().getRequestableDimension().retrieveRequestableValue();
    }
}

