/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wms13.core.dgiwg.testsuite.getmap;

import de.latlon.ets.core.assertion.ETSAssert;
import de.latlon.ets.core.error.ErrorMessage;
import de.latlon.ets.core.error.ErrorMessageKey;
import de.latlon.ets.wms13.core.dgiwg.testsuite.getmap.BaseGetMapFixture;
import de.latlon.ets.wms13.core.domain.ProtocolBinding;
import de.latlon.ets.wms13.core.util.ServiceMetadataUtils;
import jakarta.ws.rs.core.Response;
import jakarta.xml.soap.SOAPException;
import java.net.URI;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class GetMapOutputFormatTest
extends BaseGetMapFixture {
    @BeforeMethod
    public void clearRequest() {
        this.reqEntity.removeKvp("FORMAT");
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.5.3.2., S.9, Requirement 5")
    public void wmsCapabilitiesOutputFormatImagePngSupported() throws SOAPException {
        String xPathXml = "//wms:WMS_Capabilities/wms:Capability/wms:Request/wms:GetMap/wms:Format/text() = 'image/png'";
        ETSAssert.assertXPath(xPathXml, this.wmsCapabilities, NS_BINDINGS);
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.5.3.2., S.9, Requirement 5")
    public void wmsCapabilitiesOutputFormatImageGifSupported() throws SOAPException {
        String xPathHtml = "//wms:WMS_Capabilities/wms:Capability/wms:Request/wms:GetMap/wms:Format/text() = 'image/gif'";
        ETSAssert.assertXPath(xPathHtml, this.wmsCapabilities, NS_BINDINGS);
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.5.3.2., S.9, Requirement 5")
    public void wmsCapabilitiesOutputFormatImageJpegSupported() throws SOAPException {
        String xPathHtml = "//wms:WMS_Capabilities/wms:Capability/wms:Request/wms:GetMap/wms:Format/text() = 'image/jpeg'";
        ETSAssert.assertXPath(xPathHtml, this.wmsCapabilities, NS_BINDINGS);
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.5.3.2., S.9, Requirement 5", dependsOnMethods={"wmsCapabilitiesOutputFormatImagePngSupported"})
    public void wmsGetMapOutputFormatImagePngSupported() throws SOAPException {
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wmsCapabilities, "GetMap", ProtocolBinding.GET);
        this.reqEntity.addKvp("FORMAT", "image/png");
        Response rsp = this.wmsClient.submitRequest(this.reqEntity, endpoint);
        Assert.assertTrue(rsp.hasEntity(), ErrorMessage.get(ErrorMessageKey.MISSING_XML_ENTITY));
        ETSAssert.assertContentType(rsp.getHeaders(), "image/png");
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.5.3.2., S.9, Requirement 5", dependsOnMethods={"wmsCapabilitiesOutputFormatImageGifSupported"})
    public void wmsGetMapOutputFormatImageGifSupported() throws SOAPException {
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wmsCapabilities, "GetMap", ProtocolBinding.GET);
        this.reqEntity.addKvp("FORMAT", "image/gif");
        Response rsp = this.wmsClient.submitRequest(this.reqEntity, endpoint);
        Assert.assertTrue(rsp.hasEntity(), ErrorMessage.get(ErrorMessageKey.MISSING_XML_ENTITY));
        ETSAssert.assertContentType(rsp.getHeaders(), "image/gif");
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.5.3.2., S.9, Requirement 5", dependsOnMethods={"wmsCapabilitiesOutputFormatImageJpegSupported"})
    public void wmsGetMapOutputFormatImageJpegSupported() throws SOAPException {
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wmsCapabilities, "GetMap", ProtocolBinding.GET);
        this.reqEntity.addKvp("FORMAT", "image/jpeg");
        Response rsp = this.wmsClient.submitRequest(this.reqEntity, endpoint);
        Assert.assertTrue(rsp.hasEntity(), ErrorMessage.get(ErrorMessageKey.MISSING_XML_ENTITY));
        ETSAssert.assertContentType(rsp.getHeaders(), "image/jpeg");
    }
}

