/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wms13.core.domain.dimension.date;

import de.latlon.ets.wms13.core.domain.dimension.RequestableDimension;
import jakarta.xml.bind.DatatypeConverter;
import org.joda.time.DateTime;

public class DateTimeRequestableDimension
implements RequestableDimension {
    private final DateTime value;

    public DateTimeRequestableDimension(DateTime value) {
        this.value = value;
    }

    @Override
    public String retrieveRequestableValue() {
        return DatatypeConverter.printDateTime(this.value.toGregorianCalendar());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateTimeRequestableDimension other = (DateTimeRequestableDimension)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return "DateTimeRequestableDimension [value=" + this.value + "]";
    }

    public DateTime getValue() {
        return this.value;
    }
}

