/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.ArrayList;
import java.util.Stack;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.Bindery;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.GeneralVariable;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.UnfailingIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionLibrary;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.XPathException;

public class GlobalVariable
extends GeneralVariable
implements Container {
    private Executable executable;
    private SlotManager stackFrameMap = null;
    private int hostLanguage;

    public Executable getExecutable() {
        return this.executable;
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    public void setHostLanguage(int language) {
        this.hostLanguage = language;
    }

    public int getHostLanguage() {
        return this.hostLanguage;
    }

    public void setContainsLocals(SlotManager map) {
        this.stackFrameMap = map;
    }

    public boolean isGlobal() {
        return true;
    }

    public void lookForCycles(Stack referees, XQueryFunctionLibrary globalFunctionLibrary) throws XPathException {
        if (referees.contains(this)) {
            int s2 = referees.indexOf(this);
            referees.push(this);
            String message = "Circular definition of global variable. $" + this.getVariableQName().getDisplayName();
            for (int i = s2; i < referees.size() - 1; ++i) {
                Container next;
                if (i != s2) {
                    message = message + ", which";
                }
                if (referees.get(i + 1) instanceof GlobalVariable) {
                    next = (GlobalVariable)referees.get(i + 1);
                    message = message + " uses $" + ((GeneralVariable)((Object)next)).getVariableQName().getDisplayName();
                    continue;
                }
                if (!(referees.get(i + 1) instanceof XQueryFunction)) continue;
                next = (XQueryFunction)referees.get(i + 1);
                message = message + " calls " + ((XQueryFunction)next).getFunctionName().getDisplayName() + "#" + ((XQueryFunction)next).getNumberOfArguments() + "()";
            }
            message = message + '.';
            XPathException err = new XPathException(message);
            err.setErrorCode("XQST0054");
            err.setIsStaticError(true);
            err.setLocator(this);
            throw err;
        }
        if (this.select != null) {
            int i;
            referees.push(this);
            ArrayList list = new ArrayList(10);
            ExpressionTool.gatherReferencedVariables(this.select, list);
            for (i = 0; i < list.size(); ++i) {
                Binding b = (Binding)list.get(i);
                if (!(b instanceof GlobalVariable)) continue;
                ((GlobalVariable)b).lookForCycles(referees, globalFunctionLibrary);
            }
            list.clear();
            ExpressionTool.gatherCalledFunctionNames(this.select, list);
            for (i = 0; i < list.size(); ++i) {
                XQueryFunction f = globalFunctionLibrary.getDeclarationByKey((String)list.get(i));
                if (referees.contains(f)) continue;
                GlobalVariable.lookForFunctionCycles(f, referees, globalFunctionLibrary);
            }
            referees.pop();
        }
    }

    private static void lookForFunctionCycles(XQueryFunction f, Stack referees, XQueryFunctionLibrary globalFunctionLibrary) throws XPathException {
        int i;
        Expression body = f.getBody();
        referees.push(f);
        ArrayList list = new ArrayList(10);
        ExpressionTool.gatherReferencedVariables(body, list);
        for (i = 0; i < list.size(); ++i) {
            Binding b = (Binding)list.get(i);
            if (!(b instanceof GlobalVariable)) continue;
            ((GlobalVariable)b).lookForCycles(referees, globalFunctionLibrary);
        }
        list.clear();
        ExpressionTool.gatherCalledFunctionNames(body, list);
        for (i = 0; i < list.size(); ++i) {
            XQueryFunction qf = globalFunctionLibrary.getDeclarationByKey((String)list.get(i));
            if (referees.contains(qf)) continue;
            GlobalVariable.lookForFunctionCycles(qf, referees, globalFunctionLibrary);
        }
        referees.pop();
    }

    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        return null;
    }

    public ValueRepresentation getSelectValue(XPathContext context) throws XPathException {
        if (this.select == null) {
            throw new AssertionError((Object)("*** No select expression for global variable $" + this.getVariableQName().getDisplayName() + "!!"));
        }
        XPathContextMajor c2 = context.newCleanContext();
        c2.setOrigin(this);
        UnfailingIterator initialNode = SingletonIterator.makeIterator(c2.getController().getContextForGlobalVariables());
        initialNode.next();
        c2.setCurrentIterator(initialNode);
        if (this.stackFrameMap != null) {
            c2.openStackFrame(this.stackFrameMap);
        }
        return ExpressionTool.evaluate(this.select, this.evaluationMode, c2, this.referenceCount);
    }

    public ValueRepresentation evaluateVariable(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        Bindery b = controller.getBindery();
        ValueRepresentation v = b.getGlobalVariable(this.getSlotNumber());
        if (v != null) {
            return v;
        }
        try {
            b.setExecuting(this, true);
            ValueRepresentation value = this.getSelectValue(context);
            b.defineGlobalVariable(this, value);
            b.setExecuting(this, false);
            return value;
        }
        catch (XPathException err) {
            b.setExecuting(this, false);
            if (err instanceof XPathException.Circularity) {
                XPathException e = new XPathException("Circular definition of variable " + this.getVariableQName().getDisplayName());
                int lang = this.getHostLanguage();
                e.setErrorCode(lang == 51 ? "XQST0054" : "XTDE0640");
                e.setXPathContext(context);
                this.select = new ErrorExpression(e);
                e.setLocator(this);
                throw e;
            }
            throw err;
        }
    }

    public InstructionInfo getInstructionInfo() {
        InstructionDetails details = new InstructionDetails();
        details.setConstructType(this.getInstructionNameCode());
        details.setObjectName(this.getVariableQName());
        details.setProperty("expression", this);
        details.setSystemId(this.getSystemId());
        details.setLineNumber(this.getLineNumber());
        details.setColumnNumber(this.getColumnNumber());
        return details;
    }
}

