/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfxml.xmlinput0;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFErrorHandler;
import org.apache.jena.rdfxml.xmlinput0.ALiteral;
import org.apache.jena.rdfxml.xmlinput0.ARPHandlers;
import org.apache.jena.rdfxml.xmlinput0.AResource;
import org.apache.jena.rdfxml.xmlinput0.NamespaceHandler;
import org.apache.jena.rdfxml.xmlinput0.RDFXMLReader0;
import org.apache.jena.rdfxml.xmlinput0.StatementHandler;
import org.apache.jena.rdfxml.xmlinput0.impl.ARPSaxErrorHandler;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;

final class JenaHandler
extends ARPSaxErrorHandler
implements StatementHandler,
NamespaceHandler {
    private final PrefixMapping prefixMapping;
    protected int here = 0;
    private final Graph graph;

    public JenaHandler(Model m4, RDFErrorHandler e) {
        this(m4.getGraph(), e);
    }

    public JenaHandler(Graph g2, Model m4, RDFErrorHandler e) {
        this(g2, JenaHandler.modelToPrefixMapping(m4), e);
    }

    private JenaHandler(Graph graph, RDFErrorHandler e) {
        this(graph, graph.getPrefixMapping(), e);
    }

    private JenaHandler(Graph graph, PrefixMapping prefixMapping, RDFErrorHandler errorHandler) {
        super(errorHandler);
        this.graph = graph;
        this.prefixMapping = prefixMapping;
    }

    private static PrefixMapping modelToPrefixMapping(Model model) {
        return model == null ? PrefixMapping.Factory.create() : model.getGraph().getPrefixMapping();
    }

    public void useWith(ARPHandlers h2) {
        h2.setStatementHandler(this);
        h2.setErrorHandler(this);
        h2.setNamespaceHandler(this);
    }

    @Override
    public void statement(AResource subj, AResource pred, AResource obj) {
        try {
            Triple t2 = RDFXMLReader0.convert(subj, pred, obj);
            this.graph.add(t2);
        }
        catch (JenaException e) {
            this.errorHandler.error(e);
        }
    }

    @Override
    public void statement(AResource subj, AResource pred, ALiteral lit) {
        try {
            Triple t2 = RDFXMLReader0.convert(subj, pred, lit);
            this.graph.add(t2);
        }
        catch (JenaException e) {
            this.errorHandler.error(e);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        if (PrefixMappingImpl.isNiceURI(uri)) {
            this.prefixMapping.setNsPrefix(prefix, uri);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) {
    }
}

