/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys.builtins;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.reasoner.rulesys.BindingEnvironment;
import org.apache.jena.reasoner.rulesys.BuiltinException;
import org.apache.jena.reasoner.rulesys.RuleContext;
import org.apache.jena.reasoner.rulesys.builtins.BaseBuiltin;

public class Regex
extends BaseBuiltin {
    @Override
    public String getName() {
        return "regex";
    }

    @Override
    public int getArgLength() {
        return 0;
    }

    @Override
    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        if (length < 2) {
            throw new BuiltinException(this, context, "Must have at least 2 arguments to " + this.getName());
        }
        String text = this.getString(this.getArg(0, args, context), context);
        String pattern = this.getString(this.getArg(1, args, context), context);
        Matcher m4 = Pattern.compile(pattern).matcher(text);
        if (!m4.matches()) {
            return false;
        }
        if (length > 2) {
            BindingEnvironment env = context.getEnv();
            for (int i = 0; i < Math.min(length - 2, m4.groupCount()); ++i) {
                Node match;
                String gm = m4.group(i + 1);
                Node node = match = gm != null ? NodeFactory.createLiteral(gm) : NodeFactory.createLiteral("");
                if (env.bind(args[i + 2], match)) continue;
                return false;
            }
        }
        return true;
    }

    protected String getString(Node n, RuleContext context) {
        if (n.isLiteral()) {
            return n.getLiteralLexicalForm();
        }
        throw new BuiltinException(this, context, this.getName() + " takes only literal arguments");
    }
}

