/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.exception;

import org.xml.sax.SAXException;

public class WriteLimitReachedException
extends SAXException {
    private static final int MAX_DEPTH = 100;
    private final int writeLimit;

    public WriteLimitReachedException(int writeLimit) {
        this.writeLimit = writeLimit;
    }

    @Override
    public String getMessage() {
        return "Your document contained more than " + this.writeLimit + " characters, and so your requested limit has been reached. To receive the full text of the document, increase your limit. (Text up to the limit is however available).";
    }

    public static boolean isWriteLimitReached(Throwable t2) {
        return WriteLimitReachedException.isWriteLimitReached(t2, 0);
    }

    private static boolean isWriteLimitReached(Throwable t2, int depth) {
        if (t2 == null) {
            return false;
        }
        if (depth > 100) {
            return false;
        }
        if (t2 instanceof WriteLimitReachedException) {
            return true;
        }
        return WriteLimitReachedException.isWriteLimitReached(t2.getCause(), depth + 1);
    }

    public static void throwIfWriteLimitReached(Exception ex) throws SAXException {
        WriteLimitReachedException.throwIfWriteLimitReached(ex, 0);
    }

    private static void throwIfWriteLimitReached(Throwable ex, int depth) throws SAXException {
        if (ex == null) {
            return;
        }
        if (depth > 100) {
            return;
        }
        if (ex instanceof WriteLimitReachedException) {
            throw (SAXException)ex;
        }
        WriteLimitReachedException.throwIfWriteLimitReached(ex.getCause(), depth + 1);
    }
}

