/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.typelib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.glassfish.gmbal.typelib.EvaluatedClassDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedFieldDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedMethodDeclaration;
import org.glassfish.pfl.basic.algorithm.Graph;
import org.glassfish.pfl.basic.func.UnaryPredicate;

public class EvaluatedClassAnalyzer {
    private static final Graph.Finder<EvaluatedClassDeclaration> finder = new Graph.Finder<EvaluatedClassDeclaration>(){

        @Override
        public List<EvaluatedClassDeclaration> evaluate(EvaluatedClassDeclaration arg) {
            return arg.inheritance();
        }
    };
    private final List<EvaluatedClassDeclaration> classInheritance;
    private String contents = null;

    private EvaluatedClassAnalyzer(Graph<EvaluatedClassDeclaration> gr) {
        ArrayList<EvaluatedClassDeclaration> result = new ArrayList<EvaluatedClassDeclaration>(gr.getPostorderList());
        Collections.reverse(result);
        this.classInheritance = result;
    }

    public EvaluatedClassAnalyzer(EvaluatedClassDeclaration cls) {
        this(new Graph<EvaluatedClassDeclaration>(cls, finder));
    }

    public EvaluatedClassAnalyzer(List<EvaluatedClassDeclaration> decls) {
        this(new Graph<EvaluatedClassDeclaration>((EvaluatedClassDeclaration)((Object)decls), finder));
    }

    public List<EvaluatedClassDeclaration> findClasses(UnaryPredicate<EvaluatedClassDeclaration> pred) {
        ArrayList<EvaluatedClassDeclaration> result = new ArrayList<EvaluatedClassDeclaration>();
        for (EvaluatedClassDeclaration c : this.classInheritance) {
            if (!pred.evaluate(c)) continue;
            result.add(c);
        }
        return result;
    }

    public List<EvaluatedMethodDeclaration> findMethods(UnaryPredicate<EvaluatedMethodDeclaration> pred) {
        ArrayList<EvaluatedMethodDeclaration> result = new ArrayList<EvaluatedMethodDeclaration>();
        for (EvaluatedClassDeclaration c : this.classInheritance) {
            for (EvaluatedMethodDeclaration m4 : c.methods()) {
                if (!pred.evaluate(m4)) continue;
                result.add(m4);
            }
        }
        return result;
    }

    public List<EvaluatedFieldDeclaration> findFields(UnaryPredicate<EvaluatedFieldDeclaration> pred) {
        ArrayList<EvaluatedFieldDeclaration> result = new ArrayList<EvaluatedFieldDeclaration>();
        for (EvaluatedClassDeclaration c : this.classInheritance) {
            for (EvaluatedFieldDeclaration f : c.fields()) {
                if (!pred.evaluate(f)) continue;
                result.add(f);
            }
        }
        return result;
    }

    public synchronized String toString() {
        if (this.contents == null) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            sb.append("ClassAnalyzer[");
            for (EvaluatedClassDeclaration cls : this.classInheritance) {
                if (first) {
                    first = false;
                } else {
                    sb.append(" ");
                }
                sb.append(cls.name());
            }
            sb.append("]");
            this.contents = sb.toString();
        }
        return this.contents;
    }
}

