/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.basic.algorithm;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.glassfish.pfl.basic.algorithm.Graph;
import org.glassfish.pfl.basic.func.UnaryPredicate;

public class ClassAnalyzer {
    private static final Graph.Finder<Class<?>> finder = new Graph.Finder<Class<?>>(){

        @Override
        public List<Class<?>> evaluate(Class<?> arg) {
            ArrayList result = new ArrayList();
            Class<?> sclass = arg.getSuperclass();
            if (sclass != null) {
                result.add(sclass);
            }
            for (Class<?> cls : arg.getInterfaces()) {
                result.add(cls);
            }
            return result;
        }
    };
    private static Map<Class<?>, ClassAnalyzer> caMap = new WeakHashMap();
    private List<Class<?>> classInheritance;
    private String contents = null;

    public static synchronized ClassAnalyzer getClassAnalyzer(Class<?> cls) {
        ClassAnalyzer result = caMap.get(cls);
        if (result == null) {
            result = new ClassAnalyzer(cls);
            caMap.put(cls, result);
        }
        return result;
    }

    private ClassAnalyzer(Graph<Class<?>> gr) {
        ArrayList result = new ArrayList(gr.getPostorderList());
        Collections.reverse(result);
        this.classInheritance = result;
    }

    private ClassAnalyzer(Class<?> cls) {
        this(new Graph(cls, finder));
    }

    public List<Class<?>> findClasses(UnaryPredicate<Class<?>> pred) {
        ArrayList result = new ArrayList();
        for (Class<?> c : this.classInheritance) {
            if (!pred.evaluate(c)) continue;
            result.add(c);
        }
        return result;
    }

    private static List<Method> getDeclaredMethods(final Class<?> cls) {
        SecurityManager sman = System.getSecurityManager();
        if (sman == null) {
            return Arrays.asList(cls.getDeclaredMethods());
        }
        return AccessController.doPrivileged(new PrivilegedAction<List<Method>>(){

            @Override
            public List<Method> run() {
                return Arrays.asList(cls.getDeclaredMethods());
            }
        });
    }

    public List<Method> findMethods(UnaryPredicate<Method> pred) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Class<?> c : this.classInheritance) {
            for (Method m4 : ClassAnalyzer.getDeclaredMethods(c)) {
                if (!pred.evaluate(m4)) continue;
                result.add(m4);
            }
        }
        return result;
    }

    public synchronized String toString() {
        if (this.contents == null) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            sb.append("ClassAnalyzer[");
            for (Class<?> cls : this.classInheritance) {
                if (first) {
                    first = false;
                } else {
                    sb.append(" ");
                }
                sb.append(cls.getSimpleName());
            }
            sb.append("]");
            this.contents = sb.toString();
        }
        return this.contents;
    }
}

