/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.basic.facet;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.pfl.basic.algorithm.ClassAnalyzer;
import org.glassfish.pfl.basic.contain.Holder;
import org.glassfish.pfl.basic.facet.FacetAccessor;
import org.glassfish.pfl.basic.func.UnaryPredicate;

public class FacetAccessorImpl
implements FacetAccessor {
    private Object delegate;
    private Map<Class<?>, Object> facetMap = new HashMap();

    public FacetAccessorImpl(Object delegate) {
        this.delegate = delegate;
    }

    @Override
    public <T> T facet(Class<T> cls) {
        Object result = null;
        result = cls.isInstance(this.delegate) ? this.delegate : this.facetMap.get(cls);
        if (result == null) {
            return null;
        }
        return cls.cast(result);
    }

    @Override
    public Collection<Object> facets() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(this.facetMap.values());
        result.add(this);
        return result;
    }

    @Override
    public <T> void addFacet(final T obj) {
        if (obj.getClass().isInstance(this.delegate)) {
            throw new IllegalArgumentException("Cannot add facet of supertype of this object");
        }
        ClassAnalyzer ca = ClassAnalyzer.getClassAnalyzer(obj.getClass());
        ca.findClasses(new UnaryPredicate<Class<?>>(){

            @Override
            public boolean evaluate(Class arg) {
                FacetAccessorImpl.this.facetMap.put(arg, obj);
                return false;
            }
        });
    }

    @Override
    public Object invoke(Method method, Object ... args) {
        Object target = this.facet(method.getDeclaringClass());
        if (target == null) {
            throw new IllegalArgumentException("No facet available for method " + String.valueOf(method));
        }
        try {
            ClassAnalyzer ca = ClassAnalyzer.getClassAnalyzer(target.getClass());
            final String mname = method.getName();
            final Class[] mparams = method.getParameterTypes();
            final Holder mholder = new Holder();
            ca.findClasses(new UnaryPredicate<Class<?>>(){

                @Override
                public boolean evaluate(Class<?> arg) {
                    try {
                        if (mholder.content() == null) {
                            Method m4 = arg.getDeclaredMethod(mname, mparams);
                            mholder.content(m4);
                            return true;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return false;
                }
            });
            if (System.getSecurityManager() == null) {
                ((Method)mholder.content()).setAccessible(true);
            } else {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        ((Method)mholder.content()).setAccessible(true);
                        return null;
                    }
                });
            }
            Object result = ((Method)mholder.content()).invoke(target, args);
            return result;
        }
        catch (SecurityException ex) {
            throw new IllegalArgumentException("Exception on invocation", ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException("Exception on invocation", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Exception on invocation", ex);
        }
        catch (InvocationTargetException ex) {
            throw new IllegalArgumentException("Exception on invocation", ex);
        }
    }

    @Override
    public Object get(Field field) {
        Object result = null;
        Object target = this.facet(field.getDeclaringClass());
        try {
            result = field.get(target);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Exception on field get", ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException("Exception on field get", ex);
        }
        return result;
    }

    @Override
    public void set(Field field, Object value) {
        Object target = this.facet(field.getDeclaringClass());
        try {
            field.set(target, value);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Exception on field get", ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException("Exception on field get", ex);
        }
    }

    @Override
    public void removeFacet(Class<?> cls) {
        if (cls.isInstance(this.delegate)) {
            throw new IllegalArgumentException("Cannot add facet of supertype of this object");
        }
        ClassAnalyzer ca = ClassAnalyzer.getClassAnalyzer(cls);
        ca.findClasses(new UnaryPredicate<Class<?>>(){

            @Override
            public boolean evaluate(Class arg) {
                FacetAccessorImpl.this.facetMap.remove(arg);
                return false;
            }
        });
    }
}

