/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.tf.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.glassfish.pfl.basic.algorithm.Algorithms;
import org.glassfish.pfl.basic.logex.OperationTracer;
import org.glassfish.pfl.tf.spi.MethodMonitor;
import org.glassfish.pfl.tf.spi.MethodMonitorBase;
import org.glassfish.pfl.tf.spi.MethodMonitorFactory;
import org.glassfish.pfl.tf.spi.MethodMonitorFactoryBase;
import org.glassfish.pfl.tf.spi.MethodMonitorRegistry;
import org.glassfish.pfl.tf.spi.TimingPointType;
import org.glassfish.pfl.tf.timer.spi.Timer;
import org.glassfish.pfl.tf.timer.spi.TimerEventController;
import org.glassfish.pfl.tf.timer.spi.TimerManager;

public class MethodMonitorFactoryDefaults {
    private static Map<String, String> prefixTable = new HashMap<String, String>();
    private static MethodMonitorFactory operationTracerImpl = new MethodMonitorFactoryBase("OperationTracerImpl"){

        @Override
        public MethodMonitor create(final Class<?> cls) {
            return new MethodMonitorBase("OperationTracer", cls, this){

                @Override
                public void enter(int ident, Object ... args) {
                    String mname = MethodMonitorRegistry.getMethodName(cls, ident);
                    OperationTracer.enter(mname, args);
                }

                @Override
                public void info(Object[] args, int callerIdent, int selfIdent) {
                }

                @Override
                public void exit(int ident) {
                    OperationTracer.exit();
                }

                @Override
                public void exit(int ident, Object result) {
                    OperationTracer.exit();
                }

                @Override
                public void exception(int ident, Throwable thr) {
                }

                @Override
                public void clear() {
                    OperationTracer.clear();
                }
            };
        }
    };
    private static MethodMonitorFactory dprintImpl = new MethodMonitorFactoryBase("DprintImpl"){
        private static final boolean USE_LOGGER = false;

        @Override
        public MethodMonitor create(final Class<?> cls) {
            return new MethodMonitorBase("Dprint", cls, this){
                final String loggerName;
                final String sourceClassName;
                {
                    super(name, cls2, mmf);
                    this.loggerName = null;
                    this.sourceClassName = MethodMonitorFactoryDefaults.compressClassName(cls.getName());
                }

                public synchronized void dprint(String mname, String msg) {
                    String prefix = "(" + Thread.currentThread().getName() + "): ";
                    System.out.println(prefix + this.sourceClassName + "." + mname + msg);
                }

                private String makeString(Object ... args) {
                    if (args.length == 0) {
                        return "";
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append('(');
                    boolean first = true;
                    for (Object obj : args) {
                        if (first) {
                            first = false;
                        } else {
                            sb.append(' ');
                        }
                        sb.append(Algorithms.convertToString(obj));
                    }
                    sb.append(')');
                    return sb.toString();
                }

                @Override
                public void enter(int ident, Object ... args) {
                    String mname = MethodMonitorRegistry.getMethodName(cls, ident);
                    String str = this.makeString(args);
                    this.dprint(mname, "->" + str);
                }

                @Override
                public void exception(int ident, Throwable thr) {
                    String mname = MethodMonitorRegistry.getMethodName(cls, ident);
                    this.dprint(mname, ":throw:" + String.valueOf(thr));
                }

                @Override
                public void info(Object[] args, int callerId, int selfId) {
                    String mname = MethodMonitorRegistry.getMethodName(cls, callerId);
                    String infoName = MethodMonitorRegistry.getMethodName(cls, selfId);
                    String str = this.makeString(args);
                    this.dprint(mname, "::(" + infoName + ")" + str);
                }

                @Override
                public void exit(int ident) {
                    String mname = MethodMonitorRegistry.getMethodName(cls, ident);
                    this.dprint(mname, "<-");
                }

                @Override
                public void exit(int ident, Object retVal) {
                    String mname = MethodMonitorRegistry.getMethodName(cls, ident);
                    this.dprint(mname, "<-(" + String.valueOf(retVal) + ")");
                }

                @Override
                public void clear() {
                }
            };
        }
    };
    private static MethodMonitorFactory noOpImpl = new MethodMonitorFactoryBase("NoOp"){

        @Override
        public MethodMonitor create(Class<?> cls) {
            return new MethodMonitorBase("NoOp", cls, this){

                @Override
                public void enter(int ident, Object ... args) {
                }

                @Override
                public void info(Object[] args, int callerId, int selfId) {
                }

                @Override
                public void exit(int ident) {
                }

                @Override
                public void exit(int ident, Object result) {
                }

                @Override
                public void exception(int ident, Throwable thr) {
                }

                @Override
                public void clear() {
                }
            };
        }
    };

    private MethodMonitorFactoryDefaults() {
    }

    public static void addPrefix(String pkg, String symbol) {
        Object str = pkg.charAt(pkg.length() - 1) == '.' ? pkg : pkg + ".";
        prefixTable.put((String)str, symbol);
    }

    private static String compressClassName(String name) {
        for (Map.Entry<String, String> entry : prefixTable.entrySet()) {
            if (!name.startsWith(entry.getKey())) continue;
            return "(" + entry.getValue() + ")." + name.substring(entry.getKey().length());
        }
        return name;
    }

    public static <T> MethodMonitorFactory makeTimingImpl(final TimerManager<T> tm) {
        final String name = "Timing[" + tm.toString() + "]";
        return new MethodMonitorFactoryBase(name){

            @Override
            public MethodMonitor create(final Class<?> cls) {
                return new MethodMonitorBase(name, cls, this){
                    private TimerEventController tec;
                    private final List<Timer> timers;
                    private final List<TimingPointType> timerTypes;
                    {
                        super(name, cls2, mmf);
                        this.tec = tm.controller();
                        this.timers = tm.getTimers(cls);
                        this.timerTypes = MethodMonitorRegistry.getTimerTypes(cls);
                    }

                    @Override
                    public void enter(int ident, Object ... args) {
                        Timer tp = this.timers.get(ident);
                        this.tec.enter(tp);
                    }

                    @Override
                    public void info(Object[] args, int callerId, int selfId) {
                        Timer tp = this.timers.get(selfId);
                        if (tp != null) {
                            TimingPointType tpt = this.timerTypes.get(selfId);
                            if (tpt == TimingPointType.ENTER) {
                                this.tec.enter(tp);
                            } else if (tpt == TimingPointType.EXIT) {
                                this.tec.exit(tp);
                            }
                        }
                    }

                    @Override
                    public void exit(int ident) {
                        Timer tp = this.timers.get(ident);
                        this.tec.exit(tp);
                    }

                    @Override
                    public void exit(int ident, Object result) {
                        Timer tp = this.timers.get(ident);
                        this.tec.exit(tp);
                    }

                    @Override
                    public void exception(int ident, Throwable thr) {
                        Timer tp = this.timers.get(ident);
                        this.tec.exit(tp);
                    }

                    @Override
                    public void clear() {
                    }
                };
            }
        };
    }

    public static MethodMonitorFactory operationTracer() {
        return operationTracerImpl;
    }

    public static MethodMonitorFactory noOp() {
        return noOpImpl;
    }

    public static MethodMonitorFactory dprint() {
        return dprintImpl;
    }

    static MethodMonitor composeMM(final List<MethodMonitor> mms) {
        Iterator<MethodMonitor> iterator;
        if (mms.isEmpty()) {
            return noOpImpl.create(null);
        }
        if (mms.size() == 1 && (iterator = mms.iterator()).hasNext()) {
            MethodMonitor mm4 = iterator.next();
            return mm4;
        }
        HashSet<MethodMonitorFactory> factories = new HashSet<MethodMonitorFactory>();
        Class<?> cls = null;
        for (MethodMonitor mm5 : mms) {
            factories.add(mm5.factory());
            Class<?> mmClass = mm5.myClass();
            if (cls == null) {
                cls = mmClass;
                continue;
            }
            if (cls.equals(mmClass)) continue;
            throw new RuntimeException("MethodMonitors not composable: not all instantiated from the same class");
        }
        MethodMonitorFactory mmf = MethodMonitorFactoryDefaults.compose(factories);
        StringBuilder sb = new StringBuilder("compose(");
        boolean first = true;
        for (MethodMonitor mm6 : mms) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(mm6.name());
        }
        String name = sb.toString();
        return new MethodMonitorBase(name, cls, mmf){

            @Override
            public void enter(int ident, Object ... args) {
                for (MethodMonitor mm4 : mms) {
                    mm4.enter(ident, args);
                }
            }

            @Override
            public void info(Object[] args, int callerId, int selfId) {
                for (MethodMonitor mm4 : mms) {
                    mm4.info(args, callerId, selfId);
                }
            }

            @Override
            public void exit(int ident) {
                for (MethodMonitor mm4 : mms) {
                    mm4.exit(ident);
                }
            }

            @Override
            public void exit(int ident, Object result) {
                for (MethodMonitor mm4 : mms) {
                    mm4.exit(ident, result);
                }
            }

            @Override
            public void exception(int ident, Throwable thr) {
                for (MethodMonitor mm4 : mms) {
                    mm4.exception(ident, thr);
                }
            }

            @Override
            public void clear() {
                for (MethodMonitor mm4 : mms) {
                    mm4.clear();
                }
            }
        };
    }

    public static MethodMonitorFactory compose(Collection<MethodMonitorFactory> factories) {
        Iterator<MethodMonitorFactory> iterator;
        if (factories.isEmpty()) {
            return noOpImpl;
        }
        if (factories.size() == 1 && (iterator = factories.iterator()).hasNext()) {
            MethodMonitorFactory mmf = iterator.next();
            return mmf;
        }
        HashSet<MethodMonitorFactory> mmfs = new HashSet<MethodMonitorFactory>();
        for (MethodMonitorFactory mmf : factories) {
            mmfs.addAll(mmf.contents());
        }
        StringBuilder sb = new StringBuilder("compose(");
        boolean first = true;
        for (MethodMonitorFactory mmf : mmfs) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(mmf.name());
        }
        String name = sb.toString();
        return new MethodMonitorFactoryBase(name, mmfs){

            @Override
            public MethodMonitor create(Class<?> cls) {
                ArrayList<MethodMonitor> mms = new ArrayList<MethodMonitor>();
                for (MethodMonitorFactory mmf : this.contents()) {
                    mms.add(mmf.create(cls));
                }
                return MethodMonitorFactoryDefaults.composeMM(mms);
            }
        };
    }
}

