/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.invokers;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ISuiteRunnerListener;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.SkipException;
import org.testng.SuiteRunState;
import org.testng.collections.Maps;
import org.testng.internal.IConfiguration;
import org.testng.internal.ITestResultNotifier;
import org.testng.internal.ListenerOrderDeterminer;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.invokers.InvokedMethodListenerInvoker;
import org.testng.internal.invokers.InvokedMethodListenerMethod;

class BaseInvoker {
    private final Collection<IInvokedMethodListener> m_invokedMethodListeners;
    protected final ITestResultNotifier m_notifier;
    protected final ITestContext m_testContext;
    protected final SuiteRunState m_suiteState;
    protected IConfiguration m_configuration;
    protected final Map<Class<?>, Set<Object>> m_classInvocationResults = Maps.newConcurrentMap();
    protected final Object NULL_OBJECT = new Object();
    private final ISuiteRunnerListener suiteRunner;

    public BaseInvoker(ITestResultNotifier notifier, Collection<IInvokedMethodListener> invokedMethodListeners, ITestContext testContext, SuiteRunState suiteState, IConfiguration configuration, ISuiteRunnerListener suiteRunner) {
        this.m_notifier = notifier;
        this.m_invokedMethodListeners = invokedMethodListeners;
        this.m_testContext = testContext;
        this.m_suiteState = suiteState;
        this.m_configuration = configuration;
        this.suiteRunner = suiteRunner;
    }

    protected IAnnotationFinder annotationFinder() {
        return this.m_configuration.getAnnotationFinder();
    }

    protected void runInvokedMethodListeners(InvokedMethodListenerMethod listenerMethod, IInvokedMethod invokedMethod, ITestResult testResult) {
        List<IInvokedMethodListener> listeners;
        if (this.noListenersPresent()) {
            return;
        }
        InvokedMethodListenerInvoker invoker = new InvokedMethodListenerInvoker(listenerMethod, testResult, testResult.getTestContext());
        boolean isAfterInvocation = InvokedMethodListenerMethod.AFTER_INVOCATION == listenerMethod;
        List<IInvokedMethodListener> list = listeners = isAfterInvocation ? ListenerOrderDeterminer.reversedOrder(this.m_invokedMethodListeners) : ListenerOrderDeterminer.order(this.m_invokedMethodListeners);
        if (!isAfterInvocation) {
            this.suiteRunner.beforeInvocation(invokedMethod, testResult);
        }
        for (IInvokedMethodListener currentListener : listeners) {
            try {
                invoker.invokeListener(currentListener, invokedMethod);
            }
            catch (SkipException e) {
                String msg = String.format("Caught a [%s] exception from one of listeners %s. Will mark [%s()] as SKIPPED.", SkipException.class.getSimpleName(), currentListener.getClass().getName(), invokedMethod.getTestMethod().getQualifiedName());
                Utils.warn(msg);
                testResult.setStatus(3);
                testResult.setThrowable(e);
            }
        }
        if (isAfterInvocation) {
            this.suiteRunner.afterInvocation(invokedMethod, testResult);
        }
    }

    private boolean noListenersPresent() {
        return this.m_invokedMethodListeners == null || this.m_invokedMethodListeners.isEmpty();
    }

    protected void handleException(Throwable throwable, ITestNGMethod testMethod, ITestResult testResult, int failureCount) {
        int invocationCount;
        int successPercentage;
        float numberOfTestsThatCanFail;
        if (throwable != null && testResult.getThrowable() == null) {
            testResult.setThrowable(throwable);
        }
        if ((float)failureCount < (numberOfTestsThatCanFail = (float)((100 - (successPercentage = testMethod.getSuccessPercentage())) * (invocationCount = testMethod.getInvocationCount())) / 100.0f)) {
            testResult.setStatus(4);
        } else {
            testResult.setStatus(2);
        }
    }

    protected boolean isSkipExceptionAndSkip(Throwable ite) {
        return SkipException.class.isAssignableFrom(ite.getClass()) && ((SkipException)ite).isSkip();
    }

    static void log(int level, String s2) {
        Utils.log("Invoker " + Thread.currentThread().hashCode(), level, s2);
    }
}

