/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wms13.core.dgiwg.testsuite.getfeatureinfo;

import de.latlon.ets.core.error.ErrorMessage;
import de.latlon.ets.core.error.ErrorMessageKey;
import de.latlon.ets.wms13.core.dgiwg.testsuite.getfeatureinfo.BaseGetFeatureInfoFixture;
import de.latlon.ets.wms13.core.domain.ProtocolBinding;
import de.latlon.ets.wms13.core.util.ServiceMetadataUtils;
import jakarta.ws.rs.core.Response;
import jakarta.xml.soap.SOAPException;
import java.net.URI;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class GetFeatureInfoFeatureCountTest
extends BaseGetFeatureInfoFixture {
    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.6.5.6, S.22, Requirement 29")
    public void wmsGetFeatureInfoFeatureCountWithValueOfOne() throws SOAPException, XPathExpressionException, XPathFactoryConfigurationException {
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wmsCapabilities, "GetFeatureInfo", ProtocolBinding.GET);
        this.reqEntity.addKvp("FEATURE_COUNT", "1");
        Response rsp = this.wmsClient.submitRequest(this.reqEntity, endpoint);
        Assert.assertTrue((boolean)rsp.hasEntity(), (String)ErrorMessage.get((ErrorMessageKey)ErrorMessageKey.MISSING_XML_ENTITY));
        Document entity = (Document)rsp.readEntity(Document.class);
        NodeList featureMemberNodes = this.parseFeatureMemberNodes(entity);
        Assert.assertTrue((featureMemberNodes.getLength() == 1 ? 1 : 0) != 0, (String)"FEATURE_COUNT is set to 1, but the returned number of feature members is not exactly one!");
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.6.5.6, S.22, Requirement 29")
    public void wmsGetFeatureInfoFeatureCountWithValueOfTen() throws SOAPException, XPathExpressionException, XPathFactoryConfigurationException {
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wmsCapabilities, "GetFeatureInfo", ProtocolBinding.GET);
        this.reqEntity.addKvp("FEATURE_COUNT", "10");
        Response rsp = this.wmsClient.submitRequest(this.reqEntity, endpoint);
        Assert.assertTrue((boolean)rsp.hasEntity(), (String)ErrorMessage.get((ErrorMessageKey)ErrorMessageKey.MISSING_XML_ENTITY));
        Document entity = (Document)rsp.readEntity(Document.class);
        NodeList featureMemberNodes = this.parseFeatureMemberNodes(entity);
        Assert.assertTrue((featureMemberNodes.getLength() >= 1 ? 1 : 0) != 0, (String)"FEATURE_COUNT is set to 10, but less than one feature member is returned!");
        Assert.assertTrue((featureMemberNodes.getLength() <= 10 ? 1 : 0) != 0, (String)"FEATURE_COUNT is set to 10, but more than ten feature members are returned!");
    }
}

