/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wms13.core.crs;

import de.latlon.ets.core.util.TestSuiteLogger;
import de.latlon.ets.wms13.core.domain.BoundingBox;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class CrsMatcher {
    private static final String BBOX_FILE = "crs.properties";
    private List<BoundingBox> boundingBoxes;

    public List<String> retrieveOverlappingCrs(BoundingBox geographicBoundingBox) {
        if (geographicBoundingBox == null) {
            throw new IllegalArgumentException("geographicBoundingBox must not be null!");
        }
        if (!"CRS:84".equals(geographicBoundingBox.getCrs())) {
            throw new IllegalArgumentException("geographicBoundingBox must be in CRS:84!");
        }
        return this.findOperlappingCrs(geographicBoundingBox);
    }

    InputStream openStream() {
        return CrsMatcher.class.getResourceAsStream(BBOX_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<BoundingBox> parseBoundingBoxes() {
        ArrayList<BoundingBox> bboxes = new ArrayList<BoundingBox>();
        InputStream resource = this.openStream();
        if (resource != null) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(resource, "UTF-8"));){
                String line;
                while ((line = br.readLine()) != null) {
                    this.parseLine(bboxes, line);
                }
            }
            catch (IOException e) {
                TestSuiteLogger.log((Level)Level.WARNING, (String)"Keywords file crs.properties could not be parsed.", (Exception)e);
            }
            finally {
                this.closeQuietly(resource);
            }
        } else {
            TestSuiteLogger.log((Level)Level.WARNING, (String)"Could not find bbox file 'crs.properties'.");
        }
        return bboxes;
    }

    private void parseLine(List<BoundingBox> bboxes, String line) {
        BoundingBox bbox;
        if (!line.startsWith("#") && (bbox = this.parseBbox(line)) != null) {
            bboxes.add(bbox);
        }
    }

    private List<String> findOperlappingCrs(BoundingBox geographicBoundingBox) {
        this.parseBoundingBoxesIfRequired();
        ArrayList<String> overlappingCrs = new ArrayList<String>();
        for (BoundingBox bbox : this.boundingBoxes) {
            if (!this.overlaps(geographicBoundingBox, bbox)) continue;
            overlappingCrs.add(bbox.getCrs());
        }
        return overlappingCrs;
    }

    private synchronized void parseBoundingBoxesIfRequired() {
        if (this.boundingBoxes == null) {
            this.boundingBoxes = this.parseBoundingBoxes();
        }
    }

    private boolean overlaps(BoundingBox bbox1, BoundingBox bbox2) {
        if (bbox1.getMinX() > bbox2.getMaxX() || bbox2.getMinX() > bbox1.getMaxX()) {
            return false;
        }
        return !(bbox1.getMinY() > bbox2.getMaxY()) && !(bbox2.getMinY() > bbox1.getMaxY());
    }

    private BoundingBox parseBbox(String line) {
        String[] keyValue = line.split("=");
        if (keyValue.length != 2) {
            TestSuiteLogger.log((Level)Level.WARNING, (String)("Could not line '" + line + "'. Invalid format, must be e.g. EPSG:32661=-180,60,180,90."));
            return null;
        }
        String crs = keyValue[0].trim();
        String coords = keyValue[1].trim();
        if (crs.isEmpty() || coords.isEmpty()) {
            TestSuiteLogger.log((Level)Level.WARNING, (String)("Could not line '" + line + "'. Invalid format, must be e.g. EPSG:32661=-180,60,180,90."));
            return null;
        }
        String[] coordsArray = coords.split(",");
        if (coordsArray.length != 4) {
            TestSuiteLogger.log((Level)Level.WARNING, (String)("Could not parse line '" + line + "', number of coordinates must be 4, but is " + coordsArray.length + "."));
            return null;
        }
        return this.createBoundingBox(line, crs, coordsArray);
    }

    private BoundingBox createBoundingBox(String line, String crs, String[] coordsArray) {
        try {
            double minX = this.asDouble(coordsArray[0]);
            double minY = this.asDouble(coordsArray[1]);
            double maxX = this.asDouble(coordsArray[2]);
            double maxY = this.asDouble(coordsArray[3]);
            return new BoundingBox(crs, minX, minY, maxX, maxY);
        }
        catch (NumberFormatException e) {
            TestSuiteLogger.log((Level)Level.WARNING, (String)("Could not parse line '" + line + "', at least one of the coordinate is not a valid double."), (Exception)e);
        }
        catch (IllegalArgumentException e) {
            TestSuiteLogger.log((Level)Level.WARNING, (String)("Could not parse line '" + line + "', coordinates are not in the expected order (must be minX,minY,maxX,maxY."), (Exception)e);
        }
        return null;
    }

    private double asDouble(String coord) {
        String trimmedCoord = coord.trim();
        return Double.parseDouble(trimmedCoord);
    }

    private void closeQuietly(InputStream resource) {
        try {
            resource.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

