/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wms13.core.dgiwg.testsuite.getmap;

import de.latlon.ets.core.assertion.ETSAssert;
import de.latlon.ets.core.error.ErrorMessage;
import de.latlon.ets.core.error.ErrorMessageKey;
import de.latlon.ets.wms13.core.dgiwg.testsuite.getmap.BaseGetMapFixture;
import de.latlon.ets.wms13.core.domain.ProtocolBinding;
import de.latlon.ets.wms13.core.util.ServiceMetadataUtils;
import de.latlon.ets.wms13.core.util.request.WmsRequestBuilder;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.xml.soap.SOAPException;
import java.net.URI;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class GetMapRequestParametersTest
extends BaseGetMapFixture {
    @BeforeMethod
    public void clearRequest() {
        this.reqEntity.removeKvp("FORMAT");
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.6.3., S.19, Requirement 23")
    public void wmsGetMapRequestParametersSupported(ITestContext testContext) throws SOAPException {
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wmsCapabilities, "GetMap", ProtocolBinding.GET);
        String requestFormat = WmsRequestBuilder.getSupportedFormat(this.wmsCapabilities, "GetMap");
        this.reqEntity.addKvp("FORMAT", requestFormat);
        Response rsp = this.wmsClient.submitRequest(this.reqEntity, endpoint);
        Assert.assertTrue((boolean)rsp.hasEntity(), (String)ErrorMessage.get((ErrorMessageKey)ErrorMessageKey.MISSING_XML_ENTITY));
        this.storeResponseImage(rsp, "Requirement23", "simple", requestFormat);
        ETSAssert.assertStatusCode((int)rsp.getStatus(), (int[])new int[]{200});
        ETSAssert.assertContentType((MultivaluedMap)rsp.getHeaders(), (String)requestFormat);
    }
}

