/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wms13.core.dgiwg.testsuite.getmap;

import de.latlon.ets.core.assertion.ETSAssert;
import de.latlon.ets.core.error.ErrorMessage;
import de.latlon.ets.core.error.ErrorMessageKey;
import de.latlon.ets.wms13.core.dgiwg.testsuite.getmap.BaseGetMapFixture;
import de.latlon.ets.wms13.core.domain.ProtocolBinding;
import de.latlon.ets.wms13.core.util.ServiceMetadataUtils;
import jakarta.ws.rs.core.Response;
import jakarta.xml.soap.SOAPException;
import java.net.URI;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class GetMapTransparencyTest
extends BaseGetMapFixture {
    @BeforeMethod
    public void clearRequest() {
        this.reqEntity.removeKvp("FORMAT");
        this.reqEntity.removeKvp("TRANSPARENT");
        this.reqEntity.removeKvp("BGCOLOR");
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.6.3., S.19, Requirement 24")
    public void wmsGetMapTransparencySupported_True(ITestContext testContext) throws SOAPException {
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wmsCapabilities, "GetMap", ProtocolBinding.GET);
        String requestFormat = this.findRequiredImageFormatWithTransparencySupport();
        this.reqEntity.addKvp("FORMAT", requestFormat);
        this.reqEntity.addKvp("TRANSPARENT", "TRUE");
        this.reqEntity.addKvp("BGCOLOR", "0x000000");
        Response rsp = this.wmsClient.submitRequest(this.reqEntity, endpoint);
        Assert.assertTrue((boolean)rsp.hasEntity(), (String)ErrorMessage.get((ErrorMessageKey)ErrorMessageKey.MISSING_XML_ENTITY));
        this.storeResponseImage(rsp, "Requirement24", "transparentTrue_transparentBackground", requestFormat);
        ETSAssert.assertStatusCode((int)rsp.getStatus(), (int[])new int[]{200});
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.6.3., S.19, Requirement 24")
    public void wmsGetMapTransparencySupported_False(ITestContext testContext) throws SOAPException {
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wmsCapabilities, "GetMap", ProtocolBinding.GET);
        String requestFormat = this.findRequiredImageFormatWithTransparencySupport();
        this.reqEntity.addKvp("FORMAT", requestFormat);
        this.reqEntity.addKvp("TRANSPARENT", "FALSE");
        this.reqEntity.addKvp("BGCOLOR", "0x000000");
        Response rsp = this.wmsClient.submitRequest(this.reqEntity, endpoint);
        Assert.assertTrue((boolean)rsp.hasEntity(), (String)ErrorMessage.get((ErrorMessageKey)ErrorMessageKey.MISSING_XML_ENTITY));
        this.storeResponseImage(rsp, "Requirement24", "transparentFalse_blackBackground", requestFormat);
        ETSAssert.assertStatusCode((int)rsp.getStatus(), (int[])new int[]{200});
    }
}

