/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.expr.CollationMap;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.instruct.Bindery;
import net.sf.saxon.instruct.GlobalParameterSet;
import net.sf.saxon.instruct.GlobalVariable;
import net.sf.saxon.instruct.LocationMap;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.RuleManager;
import net.sf.saxon.trans.XPathException;

public class Executable
implements Serializable {
    private transient Configuration config;
    private Mode stripperRules;
    private boolean stripsWhitespace;
    private RuleManager ruleManager;
    private KeyManager keyManager;
    private DecimalFormatManager decimalFormatManager;
    private SlotManager globalVariableMap;
    private HashMap compiledGlobalVariables;
    private String defaultCollationName;
    private Properties defaultOutputProperties;
    private HashMap namedTemplateTable;
    private int largestPatternStackFrame = 0;
    private CollationMap collationTable;
    private HashMap characterMapIndex;
    private LocationMap locationMap;
    private HashMap queryLibraryModules;
    private boolean stripsInputTypeAnnotations;
    private FunctionLibrary functionLibrary;
    private int hostLanguage = 50;
    private HashSet requiredParams = null;
    private HashMap outputDeclarations = null;
    private String reasonUnableToCompile = null;

    public Executable(Configuration config) {
        this.setConfiguration(config);
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setHostLanguage(int language) {
        this.hostLanguage = language;
    }

    public int getHostLanguage() {
        return this.hostLanguage;
    }

    public void setRuleManager(RuleManager rm) {
        this.ruleManager = rm;
    }

    public RuleManager getRuleManager() {
        return this.ruleManager;
    }

    public Template getNamedTemplate(StructuredQName qName) {
        if (this.namedTemplateTable == null) {
            return null;
        }
        return (Template)this.namedTemplateTable.get(qName);
    }

    public void putNamedTemplate(StructuredQName templateName, Template template) {
        if (this.namedTemplateTable == null) {
            this.namedTemplateTable = new HashMap(32);
        }
        this.namedTemplateTable.put(templateName, template);
    }

    public Iterator iterateNamedTemplates() {
        if (this.namedTemplateTable == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.namedTemplateTable.values().iterator();
    }

    public FunctionLibrary getFunctionLibrary() {
        return this.functionLibrary;
    }

    public void setFunctionLibrary(FunctionLibrary functionLibrary) {
        this.functionLibrary = functionLibrary;
    }

    public void setCharacterMapIndex(HashMap cmi) {
        this.characterMapIndex = cmi;
    }

    public HashMap getCharacterMapIndex() {
        if (this.characterMapIndex == null) {
            this.characterMapIndex = new HashMap(10);
        }
        return this.characterMapIndex;
    }

    public void setStripperRules(Mode rules) {
        this.stripperRules = rules;
    }

    public Mode getStripperRules() {
        return this.stripperRules;
    }

    public void setStripsWhitespace(boolean strips) {
        this.stripsWhitespace = strips;
    }

    public Stripper newStripper() {
        return new Stripper(this.stripperRules);
    }

    public boolean stripsWhitespace() {
        return this.stripsWhitespace;
    }

    public void setStripsInputTypeAnnotations(boolean strips) {
        this.stripsInputTypeAnnotations = strips;
    }

    public boolean stripsInputTypeAnnotations() {
        return this.stripsInputTypeAnnotations;
    }

    public void setKeyManager(KeyManager km) {
        this.keyManager = km;
    }

    public KeyManager getKeyManager() {
        if (this.keyManager == null) {
            this.keyManager = new KeyManager(this.getConfiguration());
        }
        return this.keyManager;
    }

    public void setDefaultOutputProperties(Properties properties) {
        this.defaultOutputProperties = properties;
    }

    public Properties getDefaultOutputProperties() {
        if (this.defaultOutputProperties == null) {
            this.defaultOutputProperties = new Properties();
        }
        return this.defaultOutputProperties;
    }

    public void setOutputProperties(StructuredQName qName, Properties properties) {
        if (this.outputDeclarations == null) {
            this.outputDeclarations = new HashMap(5);
        }
        this.outputDeclarations.put(qName, properties);
    }

    public Properties getOutputProperties(StructuredQName qName) {
        if (this.outputDeclarations == null) {
            return null;
        }
        return (Properties)this.outputDeclarations.get(qName);
    }

    public void setDecimalFormatManager(DecimalFormatManager dfm) {
        this.decimalFormatManager = dfm;
    }

    public DecimalFormatManager getDecimalFormatManager() {
        if (this.decimalFormatManager == null) {
            this.decimalFormatManager = new DecimalFormatManager();
        }
        return this.decimalFormatManager;
    }

    public void setDefaultCollationName(String name) {
        this.defaultCollationName = name;
    }

    public String getDefaultCollationName() {
        if (this.defaultCollationName == null) {
            return "http://www.w3.org/2005/xpath-functions/collation/codepoint";
        }
        return this.defaultCollationName;
    }

    public StringCollator getDefaultCollation() {
        if (this.defaultCollationName == null) {
            return CodepointCollator.getInstance();
        }
        return this.getNamedCollation(this.defaultCollationName);
    }

    public void setCollationTable(CollationMap table) {
        this.collationTable = table;
    }

    public CollationMap getCollationTable() {
        if (this.collationTable == null) {
            this.collationTable = new CollationMap(this.config);
        }
        return this.collationTable;
    }

    public StringCollator getNamedCollation(String name) {
        if (this.collationTable == null) {
            this.collationTable = new CollationMap(this.config);
        }
        return this.collationTable.getNamedCollation(name);
    }

    public void addQueryLibraryModule(QueryModule module) {
        String uri;
        ArrayList<QueryModule> existing;
        if (this.queryLibraryModules == null) {
            this.queryLibraryModules = new HashMap(5);
        }
        if ((existing = (ArrayList<QueryModule>)this.queryLibraryModules.get(uri = module.getModuleNamespace())) == null) {
            existing = new ArrayList<QueryModule>(5);
            existing.add(module);
            this.queryLibraryModules.put(uri, existing);
        } else {
            existing.add(module);
        }
    }

    public List getQueryLibraryModules(String namespace) {
        if (this.queryLibraryModules == null) {
            return null;
        }
        return (List)this.queryLibraryModules.get(namespace);
    }

    public QueryModule getQueryModuleWithSystemId(String systemId, QueryModule topModule) {
        if (systemId.equals(topModule.getSystemId())) {
            return topModule;
        }
        Iterator miter = this.getQueryLibraryModules();
        while (miter.hasNext()) {
            QueryModule sqc = (QueryModule)miter.next();
            if (!sqc.getSystemId().equals(systemId)) continue;
            return sqc;
        }
        return null;
    }

    public Iterator getQueryLibraryModules() {
        if (this.queryLibraryModules == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        ArrayList modules = new ArrayList();
        for (List mods : this.queryLibraryModules.values()) {
            modules.addAll(mods);
        }
        return modules.iterator();
    }

    public void fixupQueryModules(QueryModule main) throws XPathException {
        main.bindUnboundVariables();
        if (this.queryLibraryModules != null) {
            for (List modules : this.queryLibraryModules.values()) {
                for (QueryModule env : modules) {
                    env.bindUnboundVariables();
                }
            }
        }
        List varDefinitions = main.fixupGlobalVariables(main.getGlobalStackFrameMap());
        main.bindUnboundFunctionCalls();
        if (this.queryLibraryModules != null) {
            for (List modules : this.queryLibraryModules.values()) {
                for (QueryModule env : modules) {
                    env.bindUnboundFunctionCalls();
                }
            }
        }
        main.checkForCircularities(varDefinitions, main.getGlobalFunctionLibrary());
        main.fixupGlobalFunctions();
        main.typeCheckGlobalVariables(varDefinitions);
        main.optimizeGlobalFunctions();
    }

    public void setPatternSlotSpace(int patternLocals) {
        this.largestPatternStackFrame = patternLocals;
    }

    public SlotManager getGlobalVariableMap() {
        if (this.globalVariableMap == null) {
            this.globalVariableMap = this.config.makeSlotManager();
        }
        return this.globalVariableMap;
    }

    public HashMap getCompiledGlobalVariables() {
        return this.compiledGlobalVariables;
    }

    public void explainGlobalVariables(ExpressionPresenter presenter) {
        if (this.compiledGlobalVariables != null) {
            presenter.startElement("globalVariables");
            for (GlobalVariable var : this.compiledGlobalVariables.values()) {
                presenter.startElement("declareVariable");
                presenter.emitAttribute("name", var.getVariableQName().getDisplayName());
                if (var.getSelectExpression() != null) {
                    var.getSelectExpression().explain(presenter);
                }
                presenter.endElement();
            }
            presenter.endElement();
        }
    }

    public void registerGlobalVariable(GlobalVariable variable) {
        if (this.compiledGlobalVariables == null) {
            this.compiledGlobalVariables = new HashMap(32);
        }
        this.compiledGlobalVariables.put(variable.getVariableQName(), variable);
    }

    public void initializeBindery(Bindery bindery) {
        bindery.allocateGlobals(this.getGlobalVariableMap());
    }

    public int getLargestPatternStackFrame() {
        return this.largestPatternStackFrame;
    }

    public void setLocationMap(LocationMap map) {
        this.locationMap = map;
    }

    public LocationMap getLocationMap() {
        return this.locationMap;
    }

    public void addRequiredParam(StructuredQName qName) {
        if (this.requiredParams == null) {
            this.requiredParams = new HashSet(5);
        }
        this.requiredParams.add(qName);
    }

    public void checkAllRequiredParamsArePresent(GlobalParameterSet params) throws XPathException {
        if (this.requiredParams == null) {
            return;
        }
        for (StructuredQName req : this.requiredParams) {
            if (params != null && params.get(req) != null) continue;
            XPathException err = new XPathException("No value supplied for required parameter " + req.getDisplayName());
            err.setErrorCode("XTDE0050");
            throw err;
        }
    }

    public void setReasonUnableToCompile(String reason) {
        this.reasonUnableToCompile = reason;
    }

    public String getReasonUnableToCompile() {
        return this.reasonUnableToCompile;
    }

    public void explainNamedTemplates(ExpressionPresenter presenter) {
        presenter.startElement("namedTemplates");
        if (this.namedTemplateTable != null) {
            for (Template t : this.namedTemplateTable.values()) {
                presenter.startElement("template");
                presenter.emitAttribute("name", t.getTemplateName().getDisplayName());
                presenter.emitAttribute("line", t.getLineNumber() + "");
                presenter.emitAttribute("module", t.getSystemId());
                if (t.getBody() != null) {
                    t.getBody().explain(presenter);
                }
                presenter.endElement();
            }
        }
        presenter.endElement();
    }
}

