package de.latlon.ets.wms13.core.dgiwg.testsuite.getcapabilities;

import static de.latlon.ets.wms13.core.domain.DGIWGWMS.GET_CAPABILITIES;
import static org.testng.Assert.assertTrue;

import java.net.URI;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;

import org.testng.annotations.Test;
import org.w3c.dom.Document;

import de.latlon.ets.wms13.core.domain.ProtocolBinding;
import de.latlon.ets.wms13.core.util.ServiceMetadataUtils;
import jakarta.ws.rs.core.Response;

/**
 * Tests if the capabilities contains a valid value for Abstract.
 *
 * @author <a href="mailto:goltz@lat-lon.de">Lyn Goltz</a>
 */
public class GetCapabilitiesAbstractTest extends AbstractBaseGetCapabilitiesFixture {

	private static final String EXPECTED_ABSTRACT = "This service implements the DGIWG WMS 1.3 profile version 1.0.";

	@Test(description = "DGIWG - Web Map Service 1.3 Profile, 6.6.2.3., S.15, Requirement 11")
	public void wmsCapabilitiesAbstractContainsProfile()
			throws XPathFactoryConfigurationException, XPathExpressionException {
		URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wmsCapabilities, GET_CAPABILITIES,
				ProtocolBinding.GET);
		Response rsp = wmsClient.submitRequest(this.reqEntity, endpoint);

		String abstractValue = parseAbstract(rsp);
		assertTrue(abstractValue.contains(EXPECTED_ABSTRACT), "Abstract is not valid, must contain the string '"
				+ EXPECTED_ABSTRACT + " but is '" + abstractValue + "'");
	}

	private String parseAbstract(Response rsp) throws XPathFactoryConfigurationException, XPathExpressionException {
		String xPathAbstract = "//wms:WMS_Capabilities/wms:Service/wms:Abstract";
		XPathFactory factory = XPathFactory.newInstance(XPathConstants.DOM_OBJECT_MODEL);
		XPath xpath = factory.newXPath();
		xpath.setNamespaceContext(NS_BINDINGS);
		return (String) xpath.evaluate(xPathAbstract, rsp.readEntity(Document.class), XPathConstants.STRING);
	}

}